/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.pcsc.kztoken;

import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import kz.gamma.hardware.crypto.pcsc.ResponceCard;
import kz.gamma.hardware.util.UtilCM;

public class TokenKzToken {
    private ResponseAPDU respApdu = null;
    private CommandAPDU capdu = null;
    private Card sc = null;
    private CardChannel ch = null;
    private TerminalFactory factory = TerminalFactory.getDefault();
    private CardTerminal terminal = null;
    private String atr;

    public TokenKzToken(String reader) throws CardException {
        this.terminal = this.factory.terminals().getTerminal(reader);
        this.sc = this.terminal.connect("T=1");
        this.atr = UtilCM.array2hex(this.sc.getATR().getBytes());
        this.ch = this.sc.getBasicChannel();
    }

    public ResponceCard getStatus() throws CardException {
        byte[] apdu = new byte[]{0, -54, 1, -119, 38};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard getSerial() throws CardException {
        byte[] apdu = new byte[]{0, -54, 1, -127, -1};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard verifyPin(byte right, String pin) throws CardException {
        this.respApdu = this.ch.transmit(new CommandAPDU(0, 32, 0, (int)right, pin.getBytes()));
        if (this.respApdu.getSW() != 36864) {
            this.respApdu = this.ch.transmit(new CommandAPDU(0, 32, 0, right));
        }
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard changePin(byte right, String pin) throws CardException {
        byte[] apdu = new byte[11 + pin.length()];
        apdu[0] = 0;
        apdu[1] = 36;
        apdu[2] = 1;
        apdu[3] = right;
        apdu[4] = (byte)(6 + pin.length());
        apdu[5] = -128;
        apdu[6] = 2;
        apdu[7] = 0;
        apdu[8] = (byte)pin.length();
        apdu[9] = -91;
        apdu[10] = (byte)pin.length();
        System.arraycopy(pin.getBytes(), 0, apdu, 11, pin.length());
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard isContainer() throws CardException {
        byte[] apdu = new byte[]{0, -92, 8, 4, 6, 16, 0, 16, 16, 16, 16};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard readContainer() throws CardException {
        int i;
        byte[] apdu = new byte[]{0, -92, 0, 4, 2, 16, 16, -1};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        byte[] data = this.respApdu.getData();
        for (i = 2; i < data[1] && data[i] != -128; ++i) {
        }
        short sz = UtilCM.byteToShort(data, i + 2, 1);
        ResponceCard responceCard = this.read(0, sz);
        return responceCard;
    }

    private ResponceCard selectMapDir() throws CardException {
        byte[] apdu = new byte[]{0, -92, 8, 4, 4, 16, 0, 16, 16};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    private ResponceCard delFile(short id) throws CardException {
        byte[] apdu = new byte[]{0, -28, 0, 0, 2, 16, 16};
        apdu[5] = (byte)(id >> 8);
        apdu[6] = (byte)(id & 0xFF);
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    private ResponceCard createFile(short id, short size, boolean isPrivate) throws CardException {
        byte access = 66;
        byte sec = 0;
        if (isPrivate) {
            access = (byte)(access | 1);
            sec = 2;
        }
        byte[] apdu = new byte[]{0, -32, 0, 0, 31, 98, 29, -126, 2, 1, 0, -128, 2, (byte)(size >> 8), (byte)(size & 0xFF), -125, 2, (byte)(id >> 8), (byte)(id & 0xFF), -122, 15, access, sec, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    private ResponceCard createDir(short id) throws CardException {
        byte[] apdu = new byte[]{0, -92, 8, 4, 2, 16, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        apdu = new byte[]{0, -32, 0, 0, 31, 98, 29, -126, 2, 56, 0, -128, 2, 0, 16, -125, 2, (byte)(id >> 8), (byte)(id & 0xFF), -122, 15, 67, 2, 2, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard writeContainer(byte[] cont) throws CardException {
        ResponceCard responceCard = this.selectMapDir();
        if (responceCard.getRetCode() != 36864) {
            if (responceCard.getRetCode() != 27266) {
                throw new CardException(Integer.toString(responceCard.getRetCode()));
            }
            responceCard = this.createDir((short)4112);
            if (responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(responceCard.getRetCode()));
            }
        }
        responceCard = this.delFile((short)4112);
        responceCard = this.createFile((short)4112, (short)cont.length, false);
        if (responceCard.getRetCode() != 36864) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        responceCard = this.write(0, cont);
        return responceCard;
    }

    public ResponceCard write(int offset, byte[] data) throws CardException {
        int len = data.length - offset;
        int part = 250;
        for (int curr = 0; curr < len; curr += part) {
            if (part > len - curr) {
                part = len - curr;
            }
            byte[] apdu = new byte[part + 5];
            apdu[0] = 0;
            apdu[1] = -42;
            apdu[2] = (byte)(curr >> 8);
            apdu[3] = (byte)(curr & 0xFF);
            apdu[4] = (byte)part;
            System.arraycopy(data, curr + offset, apdu, 5, part);
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) break;
        }
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard read(int offset, int size) throws CardException {
        byte[] fl = null;
        fl = new byte[size];
        int part = 250;
        byte[] apdu = new byte[5];
        for (int curr = 0; curr < size; curr += part) {
            if (part > size - curr) {
                part = size - curr;
            }
            apdu[0] = 0;
            apdu[1] = -80;
            apdu[2] = (byte)(curr >> 8);
            apdu[3] = (byte)(curr & 0xFF);
            apdu[4] = (byte)part;
            this.capdu = new CommandAPDU(apdu);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) break;
            System.arraycopy(this.respApdu.getData(), 0, fl, curr + offset, part);
        }
        return new ResponceCard(this.respApdu.getSW(), fl == null ? this.respApdu.getData() : fl);
    }

    public ResponceCard getPathDir(byte type, boolean isDir, byte id) throws CardException {
        byte[] apdu = new byte[]{0, -54, 1, type, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        int len = this.respApdu.getData().length;
        if (!isDir) {
            len += 2;
        }
        apdu = new byte[5 + len];
        apdu[0] = 0;
        apdu[1] = -92;
        apdu[2] = 8;
        apdu[3] = 4;
        apdu[4] = (byte)len;
        System.arraycopy(this.respApdu.getData(), 0, apdu, 5, this.respApdu.getData().length);
        if (!isDir) {
            apdu[this.respApdu.getData().length + 6] = id;
        }
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getFCP(byte id) throws CardException {
        byte[] apdu = new byte[]{0, -92, 0, 4, 2, 0, id, -1};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public int findIndx(byte tag, byte[] data) {
        int i;
        for (i = 2; i < data.length && data[i] != tag; ++i) {
        }
        return i;
    }

    public ResponceCard genKeyPair(int algType, byte newId) throws CardException {
        byte keyAlgID = 32;
        byte ex = 0;
        if (algType == 1) {
            keyAlgID = 32;
            ex = 0;
        } else if (algType == 2) {
            keyAlgID = 32;
            ex = 1;
        } else {
            throw new IllegalArgumentException("Unknown algorithm type: " + algType);
        }
        ResponceCard responceCard = this.getPathDir((byte)33, false, newId);
        if (responceCard.getRetCode() == 36864 && (responceCard = this.delFile(newId)).getRetCode() != 36864) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        byte[] apdu = new byte[]{0, -32, 0, 0, 39, 98, 37, -126, 2, 16, 0, -128, 2, 0, 26, -125, 2, 0, newId, -123, 6, 31, 0, 0, -1, 0, 0, -122, 15, 70, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        apdu = new byte[]{0, -32, 0, 0, 39, 98, 37, -126, 2, 16, 0, -128, 2, 0, 32, -125, 2, 0, newId, -123, 6, 3, keyAlgID, ex, -1, 0, 0, -122, 15, 71, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        apdu = new byte[]{0, -32, 0, 0, 39, 98, 37, -126, 2, 16, 0, -128, 2, 0, 64, -125, 2, 0, newId, -123, 6, 19, keyAlgID, ex, -1, 0, 0, -122, 15, 70, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        apdu = new byte[]{0, 70, -128, newId, 64};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard delObject(byte id) throws CardException {
        ResponceCard responceCard = this.getPathDir((byte)37, false, id);
        if (responceCard.getRetCode() == 36864) {
            this.delFile(id);
        } else if (responceCard.getRetCode() != 27266) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        responceCard = this.getPathDir((byte)34, false, id);
        if (responceCard.getRetCode() == 36864) {
            this.delFile(id);
        } else if (responceCard.getRetCode() != 27266) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        responceCard = this.getPathDir((byte)35, false, id);
        if (responceCard.getRetCode() == 36864) {
            this.delFile(id);
        } else if (responceCard.getRetCode() != 27266) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        responceCard = this.getPathDir((byte)33, false, id);
        if (responceCard.getRetCode() == 36864) {
            this.delFile(id);
        } else if (responceCard.getRetCode() != 27266) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        return new ResponceCard(36864);
    }

    public ResponceCard signature(byte id, byte[] hash) throws CardException {
        byte[] apdu = new byte[]{0, 34, 65, -74, 6, -107, 1, 64, -124, 1, id};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new CardException(Integer.toString(this.respApdu.getSW()));
        }
        apdu = new byte[38];
        apdu[0] = 0;
        apdu[1] = 42;
        apdu[2] = -98;
        apdu[3] = -102;
        apdu[4] = 32;
        System.arraycopy(hash, 0, apdu, 5, 32);
        apdu[37] = 64;
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW(), this.respApdu.getData());
    }

    public ResponceCard setCertificate(byte id, byte[] certBlob) throws CardException {
        ResponceCard responceCard = this.getPathDir((byte)37, true, (byte)0);
        if (responceCard.getRetCode() != 36864) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        this.delFile(id);
        responceCard = this.createFile(id, (short)certBlob.length, false);
        if (responceCard.getRetCode() != 36864) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        responceCard = this.write(0, certBlob);
        return responceCard;
    }

    public ResponceCard getCertificate(byte id) throws CardException {
        ResponceCard responceCard = this.getPathDir((byte)37, false, id);
        if (responceCard.getRetCode() != 36864) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        responceCard = this.getFCP(id);
        byte[] fcp = responceCard.getData();
        int indx = this.findIndx((byte)-128, fcp);
        short size = UtilCM.byteToShort(fcp, indx + 2, 1);
        responceCard = this.read(0, size);
        return responceCard;
    }

    public boolean isObjectExists(byte id, short type) throws CardException {
        boolean ret = false;
        byte tp = 0;
        switch (type) {
            case 0: {
                tp = 35;
                break;
            }
            case 1: {
                tp = 34;
                break;
            }
            case 2: {
                tp = 37;
                break;
            }
            default: {
                ret = false;
            }
        }
        ResponceCard responceCard = this.getPathDir(tp, false, id);
        if (responceCard.getRetCode() == 36864) {
            ret = true;
        }
        return ret;
    }

    public byte getKeyAlgID(byte id) throws CardException {
        int indx;
        byte ret = 1;
        ResponceCard responceCard = this.getFCP(id);
        if (responceCard.getRetCode() != 36864) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        byte[] data = responceCard.getData();
        byte isEx = data[(indx = this.findIndx((byte)-123, data)) + 4];
        if (isEx != 0) {
            ret = 2;
        }
        return ret;
    }

    public ResponceCard getPublicKey(byte id) throws CardException {
        ResponceCard responceCard = this.getPathDir((byte)34, false, id);
        if (responceCard.getRetCode() != 36864) {
            throw new CardException(Integer.toString(responceCard.getRetCode()));
        }
        responceCard = this.read(0, 64);
        return responceCard;
    }

    public void disconnect() throws CardException {
        this.ch.getCard().disconnect(false);
    }
}

