/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.pkcs11;

import java.util.Map;
import kz.gamma.hardware.crypto.pkcs11.PKCS11GammaObject;
import kz.gamma.hardware.crypto.pkcs11.jacarta.JaCartaGostHelper;
import kz.gamma.hardware.crypto.pkcs11.safenet.SafeNetGostHelper;
import kz.gamma.hardware.jce.CryptoObject;

public class PKCS11Helper {
    public static long CKM_GOSTR3410_KEY_PAIR_GEN = 4608L;
    public static long CKM_GOSTR3410 = 4609L;
    public static long CKK_GOSTR3410 = 48L;

    public static CryptoObject createPKCS11GammaObject() {
        try {
            return new PKCS11GammaObject();
        }
        catch (Throwable t) {
            throw new RuntimeException("PKCS11GammaObject not implemented");
        }
    }

    public static CryptoObject createSafeNetGostObject() {
        try {
            return SafeNetGostHelper.createSafeNetGostObject();
        }
        catch (Throwable t) {
            throw new RuntimeException("SafeNetGostHelper not implemented");
        }
    }

    public static CryptoObject createJaCartaGostObject() {
        try {
            return JaCartaGostHelper.createJaCartaGostObject();
        }
        catch (Throwable t) {
            throw new RuntimeException("JaCartaGostHelper not implemented");
        }
    }

    public static Map<String, String> devices() {
        try {
            return PKCS11GammaObject.devices();
        }
        catch (Throwable t) {
            throw new RuntimeException("PKCS11GammaObject not implemented");
        }
    }

    public static boolean isPKCS11Object(CryptoObject obj) {
        boolean ret = false;
        if (obj instanceof PKCS11GammaObject) {
            ret = true;
        } else if (SafeNetGostHelper.isSafeNetGostObject((CryptoObject)obj)) {
            ret = true;
        } else if (JaCartaGostHelper.isJaCartaGostObject((CryptoObject)obj)) {
            ret = true;
        }
        return ret;
    }
}

