/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.software.ocsp;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1OctetString;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.DERIA5String;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.hardware.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.hardware.asn1.ocsp.BasicOCSPResponse;
import kz.gamma.hardware.asn1.ocsp.CertID;
import kz.gamma.hardware.asn1.ocsp.CertStatus;
import kz.gamma.hardware.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gamma.hardware.asn1.ocsp.OCSPRequest;
import kz.gamma.hardware.asn1.ocsp.OCSPResponse;
import kz.gamma.hardware.asn1.ocsp.Request;
import kz.gamma.hardware.asn1.ocsp.ResponseData;
import kz.gamma.hardware.asn1.ocsp.SingleResponse;
import kz.gamma.hardware.asn1.ocsp.TBSRequest;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.GeneralName;
import kz.gamma.hardware.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.hardware.asn1.x509.X509Extension;
import kz.gamma.hardware.asn1.x509.X509Extensions;
import kz.gamma.hardware.crypto.GOST3411Digest;
import kz.gamma.hardware.crypto.software.SignatureVerifier;
import kz.gamma.hardware.jce.PrincipalUtil;
import kz.gamma.hardware.jce.X509Principal;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.util.UtilCM;
import kz.gamma.hardware.x509.extension.AuthorityKeyIdentifierStructure;

public class OCSPUtilities {
    public byte[] generateOcspRequest(byte[] certificate, String requestorName, String hashAlgorithmOid, byte[] caCertificate, String ca) throws CertificateException, IOException {
        GeneralName requestorNameLocal = null;
        if (requestorName != null && requestorName.length() > 0) {
            requestorNameLocal = new GeneralName(6, new DERIA5String(requestorName.getBytes()));
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate));
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithmOid), DERNull.INSTANCE);
        DEROctetString issuerNameHashOctetString = null;
        DEROctetString issuerKeyHashOctetString = null;
        if (ca == null) {
            throw new RuntimeException("ca cannot be null");
        }
        if (ca.equals("nca")) {
            X509Certificate rootX509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(caCertificate));
            X509Principal issuerName = PrincipalUtil.getSubjectX509Principal(rootX509Certificate);
            byte[] issuerNameBytes = issuerName.getEncoded();
            byte[] issuerNameDigest = new byte[32];
            GOST3411Digest gost3411Digest = new GOST3411Digest();
            gost3411Digest.update(issuerNameBytes, 0, issuerNameBytes.length);
            gost3411Digest.doFinal(issuerNameDigest, 0);
            issuerNameHashOctetString = new DEROctetString(issuerNameDigest);
            SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(rootX509Certificate.getPublicKey().getEncoded()).readObject());
            byte[] issuerKey = publicKeyInfo.getPublicKeyData().getBytes();
            byte[] issuerKeyDigest = new byte[32];
            gost3411Digest.reset();
            gost3411Digest.update(issuerKey, 0, issuerKey.length);
            gost3411Digest.doFinal(issuerKeyDigest, 0);
            issuerKeyHashOctetString = new DEROctetString(issuerKeyDigest);
        } else if (ca.equals("gammaca")) {
            byte[] issuerNameBytes = x509Certificate.getIssuerX500Principal().getEncoded();
            byte[] issuerNameDigest = new byte[32];
            GOST3411Digest gost3411Digest = new GOST3411Digest();
            gost3411Digest.update(issuerNameBytes, 0, issuerNameBytes.length);
            gost3411Digest.doFinal(issuerNameDigest, 0);
            issuerNameHashOctetString = new DEROctetString(issuerNameDigest);
            byte[] extValue = x509Certificate.getExtensionValue("2.5.29.35");
            AuthorityKeyIdentifierStructure keyId = new AuthorityKeyIdentifierStructure(extValue);
            byte[] issuerKeyData = keyId.getKeyIdentifier();
            issuerKeyHashOctetString = new DEROctetString(issuerKeyData);
        } else {
            throw new RuntimeException("Unknown ca: " + ca);
        }
        DERInteger serialNumber = new DERInteger(x509Certificate.getSerialNumber());
        CertID reqCert = new CertID(algId, issuerNameHashOctetString, issuerKeyHashOctetString, serialNumber);
        Request request = new Request(reqCert, null);
        DERSequence requestList = new DERSequence(request);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        oids.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(nonce.toByteArray())));
        X509Extensions requestExtensions = new X509Extensions(oids, values);
        TBSRequest tbs = new TBSRequest(requestorNameLocal, requestList, requestExtensions);
        OCSPRequest ocspRequest = new OCSPRequest(tbs, null);
        return ocspRequest.getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map verifyOcspResponse(byte[] ocspResponse) throws CertificateException, IOException {
        FilterInputStream responseStream = null;
        try {
            HashMap<String, Constable> resultMap = new HashMap<String, Constable>();
            responseStream = new ASN1InputStream(ocspResponse);
            DERObject responseObject = ((ASN1InputStream)responseStream).readObject();
            responseStream.close();
            ASN1Sequence responseSequence = (ASN1Sequence)responseObject;
            OCSPResponse response = new OCSPResponse(responseSequence);
            ASN1OctetString octetString = response.getResponseBytes().getResponse();
            responseStream = new ASN1InputStream(octetString.getOctets());
            DERObject derObject = ((ASN1InputStream)responseStream).readObject();
            BasicOCSPResponse basicOCSPResponse = BasicOCSPResponse.getInstance(derObject);
            ResponseData responseData = basicOCSPResponse.getTbsResponseData();
            ASN1Sequence responses = responseData.getResponses();
            SingleResponse singleResponse = SingleResponse.getInstance(responses.getObjectAt(0));
            CertStatus certStatus = singleResponse.getCertStatus();
            resultMap.put("status", Integer.valueOf(certStatus.getTagNo()));
            String signatureObjectIdentifier = basicOCSPResponse.getSignatureAlgorithm().getObjectId().getId();
            if (!signatureObjectIdentifier.equals(GammaObjectIndentifiers.gost34310.getId()) && !signatureObjectIdentifier.equals(KZObjectIndentifiers.GOST_34_310_SIGNATURE.getId())) {
                String message = String.format("Unknown signature algorithm: %s", signatureObjectIdentifier);
                throw new JCEHardwareException(message);
            }
            ASN1Sequence certs = basicOCSPResponse.getCerts();
            byte[] ocspServiceCertificate = certs.getObjectAt(0).getDERObject().getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(ocspServiceCertificate));
            SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(certificate.getPublicKey().getEncoded()).readObject());
            byte[] publicKeyData = publicKeyInfo.getPublicKeyData().getBytes();
            int publicKeyLength = 64;
            byte[] publicKey = UtilCM.reverseParts(publicKeyData, publicKeyData.length - publicKeyLength);
            byte[] responseDataBytes = responseData.getEncoded();
            byte[] dataHash = new byte[32];
            GOST3411Digest gost3411Digest = new GOST3411Digest();
            gost3411Digest.update(responseDataBytes, 0, responseDataBytes.length);
            gost3411Digest.doFinal(dataHash, 0);
            dataHash = UtilCM.inverseCopyByte(dataHash, 0, dataHash.length);
            byte[] signature = basicOCSPResponse.getSignature().getBytes();
            SignatureVerifier signatureVerifier = SignatureVerifier.getInstance("gost");
            Boolean valid = signatureVerifier.verify(publicKey, dataHash, signature);
            resultMap.put("valid", valid);
            HashMap<String, Constable> hashMap = resultMap;
            return hashMap;
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

