/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.jce;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.gamma.hardware.asn1.ASN1Encodable;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.DERBitString;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.hardware.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.hardware.asn1.x509.X509Name;
import kz.gamma.hardware.asn1.x509.X509ObjectIdentifiers;
import kz.gamma.hardware.cms.CMSProcessable;
import kz.gamma.hardware.cms.CMSProcessableByteArray;
import kz.gamma.hardware.cms.CMSProcessableFile;
import kz.gamma.hardware.crypto.DeviceList;
import kz.gamma.hardware.crypto.GOST3411Digest;
import kz.gamma.hardware.crypto.params.DeviceParameter;
import kz.gamma.hardware.crypto.pcsc.PcscGammaObject;
import kz.gamma.hardware.crypto.pcsc.PcscHelper;
import kz.gamma.hardware.crypto.pcsc.jacarta.aladdin.AladdinJaCartaHelper;
import kz.gamma.hardware.crypto.pcsc.jacarta.gamma.GammaJaCartaGammaObject;
import kz.gamma.hardware.crypto.pcsc.javatoken.gamma.GammaJavaTokenGammaObject;
import kz.gamma.hardware.crypto.pcsc.kztoken.KzTokenGammaObject;
import kz.gamma.hardware.crypto.pkcs11.PKCS11Helper;
import kz.gamma.hardware.crypto.software.SignatureVerifier;
import kz.gamma.hardware.jce.JCEKeyPair;
import kz.gamma.hardware.jce.JCEMessageDigest;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.jce.JCEPublicKey;
import kz.gamma.hardware.jce.Pkcs10RequestCreator;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.jce.param.CryptoParam;
import kz.gamma.hardware.jce.param.PKCS11Param;
import kz.gamma.hardware.jce.param.PcscParam;
import kz.gamma.hardware.tsp.TSPAlgorithms;
import kz.gamma.hardware.tsp.TimeStampRequest;
import kz.gamma.hardware.tsp.TimeStampRequestGenerator;
import kz.gamma.hardware.util.UtilCM;

public abstract class CryptoObject {
    protected String devName;
    protected String algName;
    private final int DEFAULT_BUF_SIZE = 32768;
    public static final String JACARTA = "JaCarta";
    public static final String ALADDIN_JACARTA = "AladdinJaCarta";
    public static final String GAMMA_JACARTA = "GammaJaCarta";
    public static final String GAMMA_JAVA_TOKEN = "JavaToken";
    public static final String RU_TOKEN = "RuToken";
    public static final String KZ_TOKEN = "KzToken";
    public static final String SAFENET_TOKEN = "SafeNetToken";
    public static final String JACARTA_TOKEN = "JaCartaToken";
    public static final String GOST = "gost";
    public static final String RSA = "rsa";
    private SignatureVerifier signatureVerifier = null;

    public static CryptoObject getInstance(Map params) {
        String reader = (String)params.get("reader");
        String algorithm = (String)params.get("algorithm");
        if (!algorithm.equals(GOST) && !algorithm.equals(RSA)) {
            throw new JCEHardwareException("Unknown algorithm: " + algorithm);
        }
        CryptoObject cryptoObject = null;
        if (reader == null || reader.trim().length() == 0) {
            cryptoObject = CryptoObject.getInstance(algorithm);
        } else {
            List<DeviceParameter> devices = DeviceList.listOfDevices("");
            for (DeviceParameter deviceParameter : devices) {
                if (!deviceParameter.getReaderName().equals(reader)) continue;
                if (algorithm.equals(GOST) && deviceParameter.isGost() && deviceParameter.getGostDeviceName() != null) {
                    cryptoObject = CryptoObject.getInstance(deviceParameter.getGostDeviceName(), algorithm);
                    if (PcscHelper.isPcscGammaObject(cryptoObject)) {
                        cryptoObject.init(new PcscParam(reader));
                        break;
                    }
                    if (PKCS11Helper.isPKCS11Object(cryptoObject)) {
                        cryptoObject.init(new PKCS11Param(reader, deviceParameter.getLibraryName(GOST), GOST));
                        break;
                    }
                    throw new JCEHardwareException("Unknown crypto object: " + cryptoObject.getClass().getName());
                }
                if (algorithm.equals(RSA) && deviceParameter.isRsa() && deviceParameter.getRsaDeviceName() != null) {
                    cryptoObject = CryptoObject.getInstance(deviceParameter.getRsaDeviceName(), algorithm);
                    cryptoObject.init(new PKCS11Param(reader, deviceParameter.getLibraryName(RSA)));
                    break;
                }
                throw new JCEHardwareException("Cannot create instance of object");
            }
            if (cryptoObject == null) {
                throw new JCEHardwareException("Device with algorithm '" + algorithm + "' was not found");
            }
        }
        return cryptoObject;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CryptoObject getInstance(String name, String alg) {
        void var2_14;
        Object var2_2 = null;
        if (alg.equals(GOST)) {
            if (name != null && name.equals(GAMMA_JACARTA)) {
                GammaJaCartaGammaObject gammaJaCartaGammaObject = new GammaJaCartaGammaObject();
            } else if (name != null && name.equals(GAMMA_JAVA_TOKEN)) {
                GammaJavaTokenGammaObject gammaJavaTokenGammaObject = new GammaJavaTokenGammaObject();
            } else if (name != null && name.equals(ALADDIN_JACARTA)) {
                CryptoObject cryptoObject = AladdinJaCartaHelper.createAladdinJaCartaGammaObject();
            } else if (name != null && name.equals(RU_TOKEN)) {
                CryptoObject cryptoObject = PKCS11Helper.createPKCS11GammaObject();
            } else if (name != null && name.equals(KZ_TOKEN)) {
                KzTokenGammaObject kzTokenGammaObject = new KzTokenGammaObject();
            } else if (name != null && name.equals(SAFENET_TOKEN)) {
                CryptoObject cryptoObject = PKCS11Helper.createSafeNetGostObject();
            } else {
                if (name == null || !name.equals(JACARTA_TOKEN)) throw new IllegalArgumentException("Wrong device name \"" + name + "\" for algorithm \"" + alg + "\"");
                CryptoObject cryptoObject = PKCS11Helper.createJaCartaGostObject();
            }
        } else {
            if (!alg.equals(RSA)) throw new IllegalArgumentException("Wrong device name \"" + name + "\" for algorithm \"" + alg + "\"");
            if (name != null && name.equals(JACARTA)) {
                CryptoObject cryptoObject = PKCS11Helper.createPKCS11GammaObject();
            } else if (name != null && name.equals(GAMMA_JAVA_TOKEN)) {
                CryptoObject cryptoObject = PKCS11Helper.createPKCS11GammaObject();
            } else if (name != null && name.equals(RU_TOKEN)) {
                CryptoObject cryptoObject = PKCS11Helper.createPKCS11GammaObject();
            } else {
                if (name == null || !name.equals(KZ_TOKEN)) throw new IllegalArgumentException("Wrong device name \"" + name + "\" for algorithm \"" + alg + "\"");
                CryptoObject cryptoObject = PKCS11Helper.createPKCS11GammaObject();
            }
        }
        var2_14.devName = name;
        var2_14.algName = alg;
        return var2_14;
    }

    public static CryptoObject getInstance(String alg) {
        CryptoObject ret = null;
        String selectedReader = null;
        String selectedDevice = null;
        if (alg.equals(GOST)) {
            Map<String, String> devicesWithReaders = PcscGammaObject.devices();
            if (devicesWithReaders.containsValue(GAMMA_JACARTA)) {
                ret = new GammaJaCartaGammaObject();
                selectedDevice = GAMMA_JACARTA;
            } else if (devicesWithReaders.containsValue(GAMMA_JAVA_TOKEN)) {
                ret = new GammaJavaTokenGammaObject();
                selectedDevice = GAMMA_JAVA_TOKEN;
            } else if (devicesWithReaders.containsValue(ALADDIN_JACARTA)) {
                ret = AladdinJaCartaHelper.createAladdinJaCartaGammaObject();
                selectedDevice = ALADDIN_JACARTA;
            } else if (devicesWithReaders.containsValue(RU_TOKEN)) {
                ret = PKCS11Helper.createPKCS11GammaObject();
                selectedDevice = RU_TOKEN;
            } else if (devicesWithReaders.containsValue(KZ_TOKEN)) {
                ret = new KzTokenGammaObject();
                selectedDevice = KZ_TOKEN;
            } else if (devicesWithReaders.containsValue(SAFENET_TOKEN)) {
                ret = PKCS11Helper.createSafeNetGostObject();
                selectedDevice = SAFENET_TOKEN;
            } else if (devicesWithReaders.containsValue(JACARTA_TOKEN)) {
                ret = PKCS11Helper.createJaCartaGostObject();
                selectedDevice = JACARTA_TOKEN;
            } else {
                throw new IllegalArgumentException("Device not found");
            }
            for (Map.Entry<String, String> entry : devicesWithReaders.entrySet()) {
                if (!entry.getValue().equals(selectedDevice)) continue;
                selectedReader = entry.getKey();
                break;
            }
            if (ret != null) {
                if (!PKCS11Helper.isPKCS11Object(ret)) {
                    ret.init(new PcscParam(selectedReader));
                } else {
                    String libraryName = null;
                    if (devicesWithReaders.containsValue(RU_TOKEN)) {
                        selectedDevice = RU_TOKEN;
                        libraryName = PKCS11Param.RUTOKEN_PKCS11_LIB_GOST_NAME;
                    } else if (devicesWithReaders.containsValue(KZ_TOKEN)) {
                        selectedDevice = KZ_TOKEN;
                        libraryName = PKCS11Param.KZTOKEN_PKCS11_LIB_NAME;
                    } else if (devicesWithReaders.containsValue(SAFENET_TOKEN)) {
                        selectedDevice = SAFENET_TOKEN;
                        libraryName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
                    } else if (devicesWithReaders.containsValue(JACARTA_TOKEN)) {
                        selectedDevice = JACARTA_TOKEN;
                        libraryName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
                    } else {
                        throw new IllegalArgumentException("Device not found");
                    }
                    ret.init(new PKCS11Param(selectedReader, libraryName, GOST));
                }
            }
        } else if (alg.equals(RSA)) {
            Map<String, String> devicesWithReaders = PKCS11Helper.devices();
            String libraryName = null;
            if (devicesWithReaders.containsValue(JACARTA)) {
                selectedDevice = JACARTA;
                libraryName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
            } else if (devicesWithReaders.containsValue(GAMMA_JAVA_TOKEN)) {
                selectedDevice = GAMMA_JAVA_TOKEN;
                libraryName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
            } else if (devicesWithReaders.containsValue(RU_TOKEN)) {
                selectedDevice = RU_TOKEN;
                libraryName = PKCS11Param.RUTOKEN_PKCS11_LIB_RSA_NAME;
            } else if (devicesWithReaders.containsValue(KZ_TOKEN)) {
                selectedDevice = KZ_TOKEN;
                libraryName = PKCS11Param.KZTOKEN_PKCS11_LIB_NAME;
            } else {
                throw new IllegalArgumentException("Device not found");
            }
            ret = PKCS11Helper.createPKCS11GammaObject();
            for (Map.Entry<String, String> entry : devicesWithReaders.entrySet()) {
                if (!entry.getValue().equals(selectedDevice)) continue;
                selectedReader = entry.getKey();
                break;
            }
            if (ret != null) {
                ret.init(new PKCS11Param(selectedReader, libraryName));
            }
        } else {
            throw new IllegalArgumentException("Unknown algorithm: " + alg);
        }
        ret.devName = selectedDevice;
        ret.algName = alg;
        return ret;
    }

    public byte[] generatePKCS10(X509Name subject, JCEPrivateKey privateKey, JCEPublicKey publicKey, ASN1Set attributes) throws NoSuchAlgorithmException {
        String publicKeyOid = null;
        String signatureOid = null;
        switch (privateKey.getAlgId()) {
            case 1: {
                publicKeyOid = GammaObjectIndentifiers.gost34310_GammaTech_A.getId();
                signatureOid = GammaObjectIndentifiers.gost34310.getId();
                break;
            }
            case 2: {
                publicKeyOid = GammaObjectIndentifiers.gost34310_GammaTech_A_EX.getId();
                signatureOid = GammaObjectIndentifiers.gost34310.getId();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                publicKeyOid = PKCSObjectIdentifiers.rsaEncryption.getId();
                signatureOid = PKCSObjectIdentifiers.sha1WithRSAEncryption.getId();
                break;
            }
            default: {
                String message = String.format("Unknown algorithm: %d", privateKey.getAlgId());
                throw new JCEHardwareException(message);
            }
        }
        Pkcs10RequestCreator pkcs10RequestCreator = new Pkcs10RequestCreator(subject, privateKey, publicKey, attributes, this, publicKeyOid, signatureOid);
        return pkcs10RequestCreator.createPkcs10();
    }

    public SubjectPublicKeyInfo generateSubjectPublicKeyInfo(JCEPrivateKey privateKey, JCEPublicKey publicKey) {
        byte[] publicKeyPrefix = new byte[]{6, 2, 0, 0, 58, -86, 0, 0, 0, 69, 67, 49, 0, 2, 0, 0};
        byte[] publicExp = new byte[]{1, 0, 1};
        String keyOid = GammaObjectIndentifiers.gost34310_GammaTech_A.getId();
        if (privateKey.getAlgId() == 1) {
            keyOid = GammaObjectIndentifiers.gost34310_GammaTech_A.getId();
        } else if (privateKey.getAlgId() == 2) {
            keyOid = GammaObjectIndentifiers.gost34310_GammaTech_A_EX.getId();
            publicKeyPrefix[4] = 69;
            publicKeyPrefix[5] = -96;
        } else if (privateKey.getAlgId() == 3 || privateKey.getAlgId() == 6) {
            keyOid = PKCSObjectIdentifiers.rsaEncryption.getId();
        } else if (privateKey.getAlgId() == 4 || privateKey.getAlgId() == 7) {
            keyOid = PKCSObjectIdentifiers.rsaEncryption.getId();
        } else if (privateKey.getAlgId() == 5 || privateKey.getAlgId() == 8) {
            keyOid = PKCSObjectIdentifiers.rsaEncryption.getId();
        }
        byte[] pKey = publicKey.getpKey();
        if (privateKey.getAlgorithm().equals("ECGOST3410")) {
            pKey = UtilCM.reverseParts(pKey, 0);
            pKey = UtilCM.concat(publicKeyPrefix, pKey);
        } else if (privateKey.getAlgorithm().equals("RSA")) {
            ASN1EncodableVector seq1 = new ASN1EncodableVector();
            seq1.add(new DERInteger(pKey));
            seq1.add(new DERInteger(publicExp));
            pKey = new DERSequence(seq1).getDEREncoded();
        }
        return new SubjectPublicKeyInfo(new AlgorithmIdentifier(new DERObjectIdentifier(keyOid), new DERNull().getDERObject()), pKey);
    }

    public Map generateSignature(byte[] tbs, JCEPrivateKey privateKey, boolean invertRsaSignature) throws NoSuchAlgorithmException {
        byte[] hash = null;
        if (privateKey.getAlgorithm().equals("ECGOST3410")) {
            hash = new byte[32];
            GOST3411Digest gost3411Digest = new GOST3411Digest();
            gost3411Digest.update(tbs, 0, tbs.length);
            gost3411Digest.doFinal(hash, 0);
            hash = UtilCM.inverseCopyByte(hash, 0, hash.length);
        } else if (privateKey.getAlgorithm().equals("RSA")) {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.reset();
            hash = messageDigest.digest(tbs);
            ASN1EncodableVector seq2 = new ASN1EncodableVector();
            seq2.add(new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, new DERNull()));
            seq2.add(new DEROctetString(hash));
            hash = new DERSequence(seq2).getDEREncoded();
        }
        byte[] sign = this.signature(privateKey, hash);
        String signOid = GammaObjectIndentifiers.gost34310.getId();
        if (privateKey.getAlgorithm().equals("ECGOST3410")) {
            sign = UtilCM.reverseParts(sign, 0);
            signOid = GammaObjectIndentifiers.gost34310.getId();
        } else if (privateKey.getAlgorithm().equals("RSA")) {
            if (invertRsaSignature) {
                sign = UtilCM.inverseByte(sign);
            }
            signOid = PKCSObjectIdentifiers.sha1WithRSAEncryption.getId();
        }
        HashMap<String, ASN1Encodable> map = new HashMap<String, ASN1Encodable>();
        map.put("algorithmIdentifier", new AlgorithmIdentifier(new DERObjectIdentifier(signOid), new DERNull()));
        map.put("signature", new DERBitString(sign));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateTimestampRequest(CMSProcessable content, String reqPolicy) throws IOException, NoSuchAlgorithmException {
        byte[] hash = null;
        String tspAlg = null;
        MessageDigest messageDigest = null;
        if (this.getAlgName().equals(RSA)) {
            tspAlg = TSPAlgorithms.SHA1;
            messageDigest = MessageDigest.getInstance("SHA1");
        } else {
            tspAlg = TSPAlgorithms.GOST3411;
            messageDigest = JCEMessageDigest.getInstance("");
        }
        messageDigest.reset();
        if (content instanceof CMSProcessableFile) {
            File file = (File)content.getContent();
            FileInputStream fileInputStream = null;
            try {
                byte[] buf = new byte[32768];
                fileInputStream = new FileInputStream(file);
                int len = 0;
                while ((len = fileInputStream.read(buf, 0, buf.length)) > 0) {
                    messageDigest.update(buf, 0, len);
                }
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (content instanceof CMSProcessableByteArray) {
            byte[] text = (byte[])content.getContent();
            messageDigest.update(text, 0, text.length);
        } else {
            throw new RuntimeException("Unknown content");
        }
        hash = messageDigest.digest();
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        if (reqPolicy != null && reqPolicy.trim().length() > 0) {
            try {
                reqGen.setReqPolicy(reqPolicy);
            }
            catch (Exception e) {
                System.err.println("Bad request policy: " + reqPolicy);
            }
        }
        reqGen.setCertReq(true);
        TimeStampRequest req = reqGen.generate(tspAlg, hash, BigInteger.valueOf(System.currentTimeMillis()));
        return req.getEncoded();
    }

    public String getDevName() {
        return this.devName;
    }

    public String getAlgName() {
        return this.algName;
    }

    public abstract void init(CryptoParam var1);

    public abstract JCEKeyPair createKey(int var1, String var2, String var3);

    public abstract byte[] signature(JCEPrivateKey var1, byte[] var2);

    public abstract Enumeration<JCEKeyPair> getKeyList(String var1);

    public abstract void setCertificate(byte[] var1, JCEPrivateKey var2);

    public boolean verify(byte[] publicKey, byte[] hash, byte[] sign) {
        if (this.signatureVerifier == null) {
            this.signatureVerifier = SignatureVerifier.getInstance(this.algName);
        }
        return this.signatureVerifier.verify(publicKey, hash, sign);
    }

    public abstract void deleteKey(String var1, String var2);

    public abstract boolean checkPassword(String var1);

    public abstract void changePassword(String var1, String var2);

    public abstract boolean checkLicense();

    public abstract int getFreeMemorySize();

    public abstract String getSerialNumber();

    public abstract byte[] makeDH(JCEPrivateKey var1, byte[] var2, byte[] var3);
}

