/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.jce;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.X509ObjectIdentifiers;
import kz.gamma.hardware.crypto.pcsc.exception.PcscException;
import kz.gamma.hardware.jce.CryptoObject;
import kz.gamma.hardware.jce.JCEMessageDigest;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.util.UtilCM;

public class JCESignature {
    private MessageDigest messageDigest;
    private CryptoObject cryptoObject;
    private JCEPrivateKey privateKey;

    public JCESignature(CryptoObject cryptoObject, JCEPrivateKey privateKey) {
        this.cryptoObject = cryptoObject;
        this.privateKey = privateKey;
        if (cryptoObject.algName.equals("gost")) {
            this.messageDigest = JCEMessageDigest.getInstance("");
            this.messageDigest.reset();
        } else if (cryptoObject.algName.equals("rsa")) {
            try {
                this.messageDigest = MessageDigest.getInstance("SHA1");
                this.messageDigest.reset();
            }
            catch (NoSuchAlgorithmException e) {
                throw new JCEHardwareException(e);
            }
        }
    }

    public JCESignature(CryptoObject cryptoObject) {
        this.cryptoObject = cryptoObject;
        if (cryptoObject.algName.equals("gost")) {
            this.messageDigest = JCEMessageDigest.getInstance("");
            this.messageDigest.reset();
        } else if (cryptoObject.algName.equals("rsa")) {
            this.messageDigest = JCEMessageDigest.getInstance("SHA1");
            this.messageDigest.reset();
        }
    }

    public void update(byte[] b, int off, int len) {
        this.messageDigest.update(b, off, len);
    }

    public void update(byte b) {
        this.update(b);
    }

    public void initSign(JCEPrivateKey key) {
        this.privateKey = key;
    }

    public void update(byte[] bytes) {
        this.messageDigest.update(bytes, 0, bytes.length);
    }

    public byte[] sign() throws PcscException {
        byte[] ret = null;
        byte[] hash = this.messageDigest.digest();
        if (this.cryptoObject.algName.equals("gost")) {
            ret = this.cryptoObject.signature(this.privateKey, UtilCM.inverseCopyByte(hash, 0, hash.length));
            ret = UtilCM.reverseParts(ret, 0);
        } else if (this.cryptoObject.algName.equals("rsa")) {
            ASN1EncodableVector seq2 = new ASN1EncodableVector();
            seq2.add(new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, new DERNull().getDERObject()));
            seq2.add(new DEROctetString(hash));
            hash = new DERSequence(seq2).getDEREncoded();
            ret = this.cryptoObject.signature(this.privateKey, hash);
        }
        return ret;
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }
}

