/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.jce;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import kz.gamma.hardware.asn1.ASN1Encodable;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.DERBitString;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.hardware.asn1.pkcs.CertificationRequest;
import kz.gamma.hardware.asn1.pkcs.CertificationRequestInfo;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.hardware.asn1.x509.X509Name;
import kz.gamma.hardware.asn1.x509.X509ObjectIdentifiers;
import kz.gamma.hardware.crypto.GOST3411Digest;
import kz.gamma.hardware.jce.CryptoObject;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.jce.JCEPublicKey;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.util.UtilCM;

public class Pkcs10RequestCreator {
    private X509Name subject;
    private JCEPrivateKey privateKey;
    private JCEPublicKey publicKey;
    private ASN1Set attributes;
    private CryptoObject cryptoObject;
    private String publicKeyOid;
    private String signatureOid;

    public Pkcs10RequestCreator(X509Name subject, JCEPrivateKey privateKey, JCEPublicKey publicKey, ASN1Set attributes, CryptoObject cryptoObject, String publicKeyOid, String signatureOid) {
        this.subject = subject;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.attributes = attributes;
        this.cryptoObject = cryptoObject;
        this.publicKeyOid = publicKeyOid;
        this.signatureOid = signatureOid;
    }

    public byte[] createPkcs10() throws NoSuchAlgorithmException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.generateSubjectPublicKeyInfo();
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(this.subject, subjectPublicKeyInfo, this.attributes);
        byte[] tbs = certificationRequestInfo.getDEREncoded();
        Map map = this.generateSignature(tbs, false);
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)map.get("algorithmIdentifier");
        DERBitString signature = (DERBitString)map.get("signature");
        CertificationRequest certificationRequest = new CertificationRequest(certificationRequestInfo, algorithmIdentifier, signature);
        return certificationRequest.getDEREncoded();
    }

    private SubjectPublicKeyInfo generateSubjectPublicKeyInfo() {
        byte[] publicKeyPrefixSignature = new byte[]{6, 2, 0, 0, 58, -86, 0, 0, 0, 69, 67, 49, 0, 2, 0, 0};
        byte[] publicKeyPrefixKeyExchange = new byte[]{6, 2, 0, 0, 69, -96, 0, 0, 0, 69, 67, 49, 0, 2, 0, 0};
        DERSequence parameters = null;
        byte[] pKey = this.publicKey.getpKey();
        if (this.publicKeyOid.equals(KZObjectIndentifiers.GOST_34_310_KEY.getId())) {
            publicKeyPrefixSignature = null;
            publicKeyPrefixKeyExchange = null;
            DERObjectIdentifier parameter1 = new DERObjectIdentifier("1.2.398.3.10.1.1.1.1.1");
            DERObjectIdentifier parameter2 = new DERObjectIdentifier("1.2.398.3.10.1.3.1.1.0");
            ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
            asn1EncodableVector.add(parameter1);
            asn1EncodableVector.add(parameter2);
            parameters = new DERSequence(asn1EncodableVector);
        }
        switch (this.privateKey.getAlgId()) {
            case 1: {
                pKey = UtilCM.reverseParts(pKey, 0);
                pKey = UtilCM.concat(publicKeyPrefixSignature, pKey);
                break;
            }
            case 2: {
                pKey = UtilCM.reverseParts(pKey, 0);
                pKey = UtilCM.concat(publicKeyPrefixKeyExchange, pKey);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                byte[] publicExp = new byte[]{1, 0, 1};
                ASN1EncodableVector seq1 = new ASN1EncodableVector();
                seq1.add(new DERInteger(pKey));
                seq1.add(new DERInteger(publicExp));
                pKey = new DERSequence(seq1).getDEREncoded();
                break;
            }
            default: {
                String message = String.format("Unknown algorithm: %d", this.privateKey.getAlgId());
                throw new JCEHardwareException(message);
            }
        }
        return new SubjectPublicKeyInfo(new AlgorithmIdentifier(new DERObjectIdentifier(this.publicKeyOid), parameters), pKey);
    }

    private Map generateSignature(byte[] tbs, boolean invertRsaSignature) throws NoSuchAlgorithmException {
        byte[] hash = null;
        switch (this.privateKey.getAlgId()) {
            case 1: 
            case 2: {
                hash = new byte[32];
                GOST3411Digest gost3411Digest = new GOST3411Digest();
                gost3411Digest.update(tbs, 0, tbs.length);
                gost3411Digest.doFinal(hash, 0);
                hash = UtilCM.inverseCopyByte(hash, 0, hash.length);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.reset();
                hash = messageDigest.digest(tbs);
                ASN1EncodableVector seq2 = new ASN1EncodableVector();
                seq2.add(new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, new DERNull()));
                seq2.add(new DEROctetString(hash));
                hash = new DERSequence(seq2).getDEREncoded();
                break;
            }
            default: {
                String message = String.format("Unknown algorithm: %d", this.privateKey.getAlgId());
                throw new JCEHardwareException(message);
            }
        }
        byte[] sign = this.cryptoObject.signature(this.privateKey, hash);
        switch (this.privateKey.getAlgId()) {
            case 1: 
            case 2: {
                sign = UtilCM.reverseParts(sign, 0);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (!invertRsaSignature) break;
                sign = UtilCM.inverseByte(sign);
                break;
            }
            default: {
                String message = String.format("Unknown algorithm: %d", this.privateKey.getAlgId());
                throw new JCEHardwareException(message);
            }
        }
        HashMap<String, ASN1Encodable> map = new HashMap<String, ASN1Encodable>();
        map.put("algorithmIdentifier", new AlgorithmIdentifier(new DERObjectIdentifier(this.signatureOid), new DERNull()));
        map.put("signature", new DERBitString(sign));
        return map;
    }
}

