/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.util;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import kz.gamma.hardware.util.UtilCM;

public class CertificateFieldsResolver {
    public static final int HEX_STRING = 0;
    public static final int BYTE_ARRAY = 1;

    public Object getSerialNumber(X509Certificate x509Certificate, Integer resultType) {
        Integer requiredLength = null;
        requiredLength = x509Certificate.getSigAlgName().equals("1.3.6.1.4.1.6801.1.2.2") ? Integer.valueOf(32) : Integer.valueOf(20);
        return this.getSerialNumber(x509Certificate.getSerialNumber(), requiredLength, resultType);
    }

    public Object getSerialNumber(BigInteger serialNumber, Integer resultType) {
        Integer requiredLength = null;
        requiredLength = serialNumber.toByteArray().length == 31 || serialNumber.toByteArray().length == 32 ? Integer.valueOf(32) : Integer.valueOf(20);
        return this.getSerialNumber(serialNumber, requiredLength, resultType);
    }

    private Object getSerialNumber(BigInteger serialNumber, Integer requiredLength, Integer resultType) {
        String sn = UtilCM.array2hex(serialNumber.toByteArray());
        if (serialNumber.toByteArray().length < requiredLength) {
            char[] snChars = new char[requiredLength * 2];
            if (serialNumber.toString().charAt(0) == '-') {
                Arrays.fill(snChars, 'F');
            } else {
                Arrays.fill(snChars, '0');
            }
            System.arraycopy(sn.toCharArray(), 0, snChars, snChars.length - sn.toCharArray().length, sn.toCharArray().length);
            sn = new String(snChars);
        }
        switch (resultType) {
            case 0: {
                return sn;
            }
            case 1: {
                return UtilCM.hex2array(sn);
            }
        }
        throw new IllegalArgumentException("Illegal data type: " + resultType);
    }
}

