/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DateUtils {
    private static DateUtils instance;

    public static DateUtils getInstance() {
        if (instance == null) {
            instance = new DateUtils();
        }
        return instance;
    }

    private DateUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date stringToDate(String stringDate) throws ParseException {
        SimpleDateFormat dateF;
        if (stringDate.endsWith("Z")) {
            if (stringDate.trim().length() == 13) {
                dateF = new SimpleDateFormat("yyMMddHHmmss'Z'");
                dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
                return dateF.parse(stringDate);
            } else {
                if (stringDate.trim().length() != 15) throw new RuntimeException("Bad time format: " + stringDate);
                dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
            }
            return dateF.parse(stringDate);
        } else if (stringDate.trim().length() == 12) {
            dateF = new SimpleDateFormat("yyMMddHHmmss");
            dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
            return dateF.parse(stringDate);
        } else {
            if (stringDate.trim().length() != 14) throw new RuntimeException("Bad time format: " + stringDate);
            dateF = new SimpleDateFormat("yyyyMMddHHmmss");
            dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        return dateF.parse(stringDate);
    }

    public String dateToString(Date date, String format) throws ParseException {
        SimpleDateFormat dateF = new SimpleDateFormat(format);
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        return dateF.format(date);
    }
}

