/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.x509.BasicConstraints;
import kz.gamma.hardware.asn1.x509.X509CertificateStructure;
import kz.gamma.hardware.asn1.x509.X509Extension;
import kz.gamma.hardware.asn1.x509.X509Extensions;
import kz.gamma.hardware.cms.CMSSignedData;
import kz.gamma.hardware.crypto.GOST3411Digest;

public class UtilCM {
    public static final String hexChars = "0123456789ABCDEF";
    public static final int SUN_CPU_ENDIAN_LITTLE = 0;
    public static final int SUN_CPU_ENDIAN_BIG = 1;
    public static final int SUN_CPU_ENDIAN = UtilCM.calculateEndian();
    private static final int MAX_BASE32_SIZE = 100;

    public static String toHexByte(int val) {
        return "" + hexChars.charAt(val >> 4 & 0xF) + hexChars.charAt(val & 0xF);
    }

    public String getHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static byte[] hex2array(String hex) {
        int hexLength = hex.length();
        byte[] data = new byte[hexLength / 2];
        for (int i = 0; i < hexLength; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static String array2hex(byte[] value) {
        String ret = "";
        for (int i = 0; i < value.length; ++i) {
            ret = ret + UtilCM.toHexByte(value[i]);
        }
        return ret;
    }

    public static String array2hex(byte[] value, int size) {
        return UtilCM.array2hex(value, 0, size);
    }

    public static String array2hex(byte[] value, int offset, int size) {
        String ret = "";
        for (int i = offset; i < offset + size; ++i) {
            ret = ret + UtilCM.toHexByte(value[i]);
        }
        return ret;
    }

    @Deprecated
    public static int byteToInt(byte[] x, int offset) {
        return UtilCM.byteToInt(x, offset, SUN_CPU_ENDIAN);
    }

    public static short byteToShort(byte[] x, int offset, int type) {
        switch (type) {
            case 0: {
                return (short)(x[offset++] & 0xFF | (x[offset++] & 0xFF) << 8);
            }
            case 1: {
                return (short)((x[offset++] & 0xFF) << 8 | x[offset++] & 0xFF);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static int byteToInt(byte[] x, int offset, int type) {
        switch (type) {
            case 0: {
                return x[offset++] & 0xFF | (x[offset++] & 0xFF) << 8 | (x[offset++] & 0xFF) << 16 | x[offset++] << 24;
            }
            case 1: {
                return x[offset++] << 24 | (x[offset++] & 0xFF) << 16 | (x[offset++] & 0xFF) << 8 | x[offset++] & 0xFF;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static long byteToLong(byte[] x, int offset, int type) {
        long result = 0L;
        switch (type) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    long tmp = x[offset++];
                    result |= (tmp & 0xFFL) << i * 8;
                }
                break;
            }
            case 1: {
                for (int i = 7; i >= 0; --i) {
                    long tmp = x[offset++];
                    result |= (tmp & 0xFFL) << i * 8;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type: " + type);
            }
        }
        return result;
    }

    @Deprecated
    public static byte[] intToByte(int x) {
        return UtilCM.intToByte(x, SUN_CPU_ENDIAN);
    }

    public static byte[] shortToByte(short x, int type) {
        byte[] out = new byte[2];
        switch (type) {
            case 0: {
                out[0] = (byte)x;
                out[1] = (byte)(x >>> 8);
                return out;
            }
            case 1: {
                out[0] = (byte)(x >>> 8);
                out[1] = (byte)x;
                return out;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static byte[] intToByte(int x, int type) {
        byte[] out = new byte[4];
        switch (type) {
            case 0: {
                out[0] = (byte)x;
                out[1] = (byte)(x >>> 8);
                out[2] = (byte)(x >>> 16);
                out[3] = (byte)(x >>> 24);
                return out;
            }
            case 1: {
                out[0] = (byte)(x >>> 24);
                out[1] = (byte)(x >>> 16);
                out[2] = (byte)(x >>> 8);
                out[3] = (byte)x;
                return out;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static byte[] longToByte(long x, int type) {
        byte[] out = new byte[8];
        switch (type) {
            case 0: {
                out[0] = (byte)x;
                out[1] = (byte)(x >>> 8);
                out[2] = (byte)(x >>> 16);
                out[3] = (byte)(x >>> 24);
                out[4] = (byte)(x >>> 32);
                out[5] = (byte)(x >>> 40);
                out[6] = (byte)(x >>> 48);
                out[7] = (byte)(x >>> 56);
                return out;
            }
            case 1: {
                out[0] = (byte)(x >>> 56);
                out[1] = (byte)(x >>> 48);
                out[2] = (byte)(x >>> 40);
                out[3] = (byte)(x >>> 32);
                out[4] = (byte)(x >>> 24);
                out[5] = (byte)(x >>> 16);
                out[6] = (byte)(x >>> 8);
                out[7] = (byte)x;
                return out;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static byte[] copyByte(byte[] x, int offset, int size) {
        byte[] out = new byte[size];
        System.arraycopy(x, offset, out, 0, size);
        return out;
    }

    public static byte[] inverseCopyByte(byte[] x, int offset, int size) {
        byte[] out = new byte[size];
        for (int i = 0; i < size; ++i) {
            out[size - i - 1] = x[offset + i];
        }
        return out;
    }

    public static byte[] inverseByte(byte[] x) {
        return UtilCM.inverseCopyByte(x, 0, x.length);
    }

    public static byte[] copyByte(byte[] x, int offset, int size, int type) {
        switch (type) {
            case 0: {
                return UtilCM.inverseCopyByte(x, offset, size);
            }
            case 1: {
                return UtilCM.copyByte(x, offset, size);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static byte[] concat(byte[] A, byte[] B) {
        if (A == null && B == null) {
            return null;
        }
        if (A == null) {
            return B;
        }
        if (B == null) {
            return A;
        }
        byte[] C = new byte[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    public static int calculateEndian() {
        String result = null;
        try {
            result = System.getProperty("sun.cpu.endian");
            if (result == null) {
                return 0;
            }
            if (result.trim().toUpperCase().equals("LITTLE")) {
                return 0;
            }
            if (result.trim().toUpperCase().equals("BIG")) {
                return 1;
            }
            return 0;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static Enumeration makeEnumeration(final Object obj) {
        Class<?> type = obj.getClass();
        if (!type.isArray()) {
            throw new IllegalArgumentException(obj.getClass().toString());
        }
        return new Enumeration(){
            int size;
            int cursor;
            {
                this.size = Array.getLength(obj);
                this.cursor = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.cursor < this.size;
            }

            public Object nextElement() {
                return Array.get(obj, this.cursor++);
            }
        };
    }

    public static byte[] makeIDKey() throws NoSuchAlgorithmException {
        Calendar calendar = Calendar.getInstance();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        return messageDigest.digest(calendar.getTime().toString().getBytes());
    }

    public static byte[] reverseParts(byte[] data, int offset) {
        byte[] firstPart = UtilCM.inverseCopyByte(data, offset, (data.length - offset) / 2);
        byte[] secondPart = UtilCM.inverseCopyByte(data, offset + (data.length - offset) / 2, (data.length - offset) / 2);
        return UtilCM.concat(firstPart, secondPart);
    }

    public static byte[] swapParts(byte[] data, int offset) {
        byte[] firstPart = UtilCM.copyByte(data, offset, (data.length - offset) / 2);
        byte[] secondPart = UtilCM.copyByte(data, offset + (data.length - offset) / 2, (data.length - offset) / 2);
        return UtilCM.concat(secondPart, firstPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCertificateBlob(byte[] blob) {
        byte[] ret = null;
        try {
            CMSSignedData signedData = new CMSSignedData(blob);
            CertStore store1 = signedData.getCertificatesAndCRLs("Collection", null);
            Collection<? extends Certificate> crtColl = store1.getCertificates(new X509CertSelector());
            Iterator<? extends Certificate> itcert = crtColl.iterator();
            if (itcert.hasNext()) {
                X509Certificate ccer = (X509Certificate)itcert.next();
                ret = ccer.getEncoded();
            }
        }
        catch (Exception e) {
            ret = null;
        }
        ASN1InputStream in = null;
        try {
            if (ret == null) {
                in = new ASN1InputStream(blob);
                DERSequence crtBlob = (DERSequence)in.readObject();
                X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(crtBlob);
                ret = x509CertificateStructure.getEncoded();
            }
        }
        catch (Exception e) {
            ret = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCertificateType(byte[] blob) {
        int ret = 0;
        ASN1InputStream in = null;
        try {
            BasicConstraints basicConstraints;
            in = new ASN1InputStream(blob);
            DERSequence crtBlob = (DERSequence)in.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(crtBlob);
            X509Extension basicConstr = x509CertificateStructure.getTBSCertificate().getExtensions().getExtension(X509Extensions.BasicConstraints);
            ret = basicConstr != null ? ((basicConstraints = new BasicConstraints((DERSequence)new ASN1InputStream(basicConstr.getValue().getOctets()).readObject())).isCA() ? (x509CertificateStructure.getIssuer().equals(x509CertificateStructure.getSubject()) ? 3 : 2) : 1) : 1;
        }
        catch (Exception e) {
            ret = 0;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static int calcCRC(byte[] data) {
        int[] crc_table = new int[256];
        int crc = 0;
        for (int i = 0; i < 256; ++i) {
            long c = i;
            for (int j = 0; j < 8; ++j) {
                long p = c & 1L;
                c = c >> 1 ^ (p != 0L ? 3988292384L : 0L);
            }
            crc_table[i] = (int)c;
        }
        for (byte b : data) {
            crc = crc >>> 8 ^ crc_table[(crc ^ b) & 0xFF];
        }
        return crc ^= 0xFFFFFFFF;
    }

    public static byte[] getGostHash(byte[] data) {
        byte[] hash = new byte[32];
        GOST3411Digest gost3411Digest = new GOST3411Digest();
        gost3411Digest.reset();
        gost3411Digest.update(data, 0, data.length);
        gost3411Digest.doFinal(hash, 0);
        return hash;
    }

    public static String hash2Ref(byte[] hash) {
        return UtilCM.bin2base32(hash, 0, 20);
    }

    public static String bin2base32(byte[] bin, int offset, int size) {
        int i;
        if (size > 100) {
            throw new RuntimeException("Max size is 100");
        }
        char[] base32 = new char[size * 8 / 5];
        byte[] bp = new byte[2];
        byte[] a = new byte[size * 8];
        String alf = "0123456789ABCDEFGHJKMNPRSTUVWXYZ";
        for (i = 0; i < size; ++i) {
            int j = 0;
            int t = 128;
            while (j < 8) {
                bp[1] = 0;
                bp[0] = bin[i + offset];
                short q1 = UtilCM.byteToShort(bp, 0, SUN_CPU_ENDIAN);
                a[i * 8 + j] = (q1 & t) != 0 ? (byte)1 : 0;
                ++j;
                t >>>= 1;
            }
        }
        for (i = 0; i < size * 8 / 5; ++i) {
            base32[i] = alf.charAt(a[i * 5] << 4 | a[i * 5 + 1] << 3 | a[i * 5 + 2] << 2 | a[i * 5 + 3] << 1 | a[i * 5 + 4]);
        }
        return new String(base32);
    }
}

