/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class X509InstanceGetter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate getX509CertificateInstance(byte[] certBody) throws NoSuchProviderException, CertificateException {
        ByteArrayInputStream bais = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            bais = new ByteArrayInputStream(certBody);
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(bais);
            return x509Certificate;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRL getX509CRLInstance(byte[] crlBody) throws NoSuchProviderException, CertificateException, CRLException {
        ByteArrayInputStream bais = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            bais = new ByteArrayInputStream(crlBody);
            X509CRL x509CRL = (X509CRL)cf.generateCRL(bais);
            return x509CRL;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

