/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DEROutputStream;

public class DERSet
extends ASN1Set {
    public DERSet() {
    }

    public DERSet(DEREncodable obj) {
        this.addObject(obj);
    }

    public DERSet(DEREncodableVector v) {
        this(v, true);
    }

    public DERSet(List<DEREncodable> v, boolean needsSorting) {
        for (DEREncodable object : v) {
            this.addObject(object);
        }
        if (needsSorting) {
            this.sort();
        }
    }

    public DERSet(ASN1Encodable[] a) {
        for (int i = 0; i != a.length; ++i) {
            this.addObject(a[i]);
        }
        this.sort();
    }

    DERSet(DEREncodableVector v, boolean needsSorting) {
        for (int i = 0; i != v.size(); ++i) {
            this.addObject(v.get(i));
        }
        if (needsSorting) {
            this.sort();
        }
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            dOut.writeObject(obj);
        }
        dOut.close();
        byte[] bytes = bOut.toByteArray();
        out.writeEncoded(49, bytes);
    }
}

