/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.cmp.CertifiedKeyPair;
import kz.gamma.asn1.cmp.PKIStatusInfo;

public class CertResponse
extends ASN1Encodable {
    private DERInteger certReqId;
    private PKIStatusInfo status;
    private CertifiedKeyPair certifiedKeyPair;
    private ASN1OctetString rspInfo;

    private CertResponse(ASN1Sequence seq) {
        this.certReqId = DERInteger.getInstance(seq.getObjectAt(0));
        this.status = PKIStatusInfo.getInstance(seq.getObjectAt(1));
        if (seq.size() >= 3) {
            if (seq.size() == 3) {
                DEREncodable o = seq.getObjectAt(2);
                if (o instanceof ASN1OctetString) {
                    this.rspInfo = ASN1OctetString.getInstance(o);
                } else {
                    this.certifiedKeyPair = CertifiedKeyPair.getInstance(o);
                }
            } else {
                this.certifiedKeyPair = CertifiedKeyPair.getInstance(seq.getObjectAt(2));
                this.rspInfo = ASN1OctetString.getInstance(seq.getObjectAt(3));
            }
        }
    }

    public static CertResponse getInstance(Object o) {
        if (o instanceof CertResponse) {
            return (CertResponse)o;
        }
        if (o instanceof ASN1Sequence) {
            return new CertResponse((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public DERInteger getCertReqId() {
        return this.certReqId;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        return this.certifiedKeyPair;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certReqId);
        v.add(this.status);
        if (this.certifiedKeyPair != null) {
            v.add(this.certifiedKeyPair);
        }
        if (this.rspInfo != null) {
            v.add(this.rspInfo);
        }
        return new DERSequence(v);
    }
}

