/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import kz.gamma.asn1.ASN1Choice;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cmp.CAKeyUpdAnnContent;
import kz.gamma.asn1.cmp.CMPCertificate;
import kz.gamma.asn1.cmp.CRLAnnContent;
import kz.gamma.asn1.cmp.CertConfirmContent;
import kz.gamma.asn1.cmp.CertRepMessage;
import kz.gamma.asn1.cmp.ErrorMsgContent;
import kz.gamma.asn1.cmp.GenMsgContent;
import kz.gamma.asn1.cmp.GenRepContent;
import kz.gamma.asn1.cmp.KeyRecRepContent;
import kz.gamma.asn1.cmp.PKIConfirmContent;
import kz.gamma.asn1.cmp.PKIMessages;
import kz.gamma.asn1.cmp.POPODecKeyChallContent;
import kz.gamma.asn1.cmp.POPODecKeyRespContent;
import kz.gamma.asn1.cmp.PollRepContent;
import kz.gamma.asn1.cmp.PollReqContent;
import kz.gamma.asn1.cmp.RevAnnContent;
import kz.gamma.asn1.cmp.RevRepContent;
import kz.gamma.asn1.cmp.RevReqContent;
import kz.gamma.asn1.crmf.CertReqMessages;
import kz.gamma.asn1.pkcs.CertificationRequest;

public class PKIBody
extends ASN1Encodable
implements ASN1Choice {
    private int tagNo;
    private ASN1Encodable body;

    public static PKIBody getInstance(Object o) {
        if (o instanceof PKIBody) {
            return (PKIBody)o;
        }
        if (o instanceof ASN1TaggedObject) {
            return new PKIBody((ASN1TaggedObject)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    private PKIBody(ASN1TaggedObject tagged) {
        this.tagNo = tagged.getTagNo();
        switch (tagged.getTagNo()) {
            case 0: {
                this.body = CertReqMessages.getInstance(tagged.getObject());
                break;
            }
            case 1: {
                this.body = CertRepMessage.getInstance(tagged.getObject());
                break;
            }
            case 2: {
                this.body = CertReqMessages.getInstance(tagged.getObject());
                break;
            }
            case 3: {
                this.body = CertRepMessage.getInstance(tagged.getObject());
                break;
            }
            case 4: {
                this.body = CertificationRequest.getInstance(tagged.getObject());
                break;
            }
            case 5: {
                this.body = POPODecKeyChallContent.getInstance(tagged.getObject());
                break;
            }
            case 6: {
                this.body = POPODecKeyRespContent.getInstance(tagged.getObject());
                break;
            }
            case 7: {
                this.body = CertReqMessages.getInstance(tagged.getObject());
                break;
            }
            case 8: {
                this.body = CertRepMessage.getInstance(tagged.getObject());
                break;
            }
            case 9: {
                this.body = CertReqMessages.getInstance(tagged.getObject());
                break;
            }
            case 10: {
                this.body = KeyRecRepContent.getInstance(tagged.getObject());
                break;
            }
            case 11: {
                this.body = RevReqContent.getInstance(tagged.getObject());
                break;
            }
            case 12: {
                this.body = RevRepContent.getInstance(tagged.getObject());
                break;
            }
            case 13: {
                this.body = CertReqMessages.getInstance(tagged.getObject());
                break;
            }
            case 14: {
                this.body = CertRepMessage.getInstance(tagged.getObject());
                break;
            }
            case 15: {
                this.body = CAKeyUpdAnnContent.getInstance(tagged.getObject());
                break;
            }
            case 16: {
                this.body = CMPCertificate.getInstance(tagged.getObject());
                break;
            }
            case 17: {
                this.body = RevAnnContent.getInstance(tagged.getObject());
                break;
            }
            case 18: {
                this.body = CRLAnnContent.getInstance(tagged.getObject());
                break;
            }
            case 19: {
                this.body = PKIConfirmContent.getInstance(tagged.getObject());
                break;
            }
            case 20: {
                this.body = PKIMessages.getInstance(tagged.getObject());
                break;
            }
            case 21: {
                this.body = GenMsgContent.getInstance(tagged.getObject());
                break;
            }
            case 22: {
                this.body = GenRepContent.getInstance(tagged.getObject());
                break;
            }
            case 23: {
                this.body = ErrorMsgContent.getInstance(tagged.getObject());
                break;
            }
            case 24: {
                this.body = CertConfirmContent.getInstance(tagged.getObject());
                break;
            }
            case 25: {
                this.body = PollReqContent.getInstance(tagged.getObject());
                break;
            }
            case 26: {
                this.body = PollRepContent.getInstance(tagged.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag number: " + tagged.getTagNo());
            }
        }
    }

    @Override
    public DERObject toASN1Object() {
        return new DERTaggedObject(true, this.tagNo, this.body);
    }
}

