/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.crmf;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;

public class POPOSigningKeyInput
extends ASN1Encodable {
    private ASN1Encodable authInfo;
    private SubjectPublicKeyInfo publicKey;

    private POPOSigningKeyInput(ASN1Sequence seq) {
        this.authInfo = (ASN1Encodable)seq.getObjectAt(0);
        this.publicKey = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(1));
    }

    public static POPOSigningKeyInput getInstance(Object o) {
        if (o instanceof POPOSigningKeyInput) {
            return (POPOSigningKeyInput)o;
        }
        if (o instanceof ASN1Sequence) {
            return new POPOSigningKeyInput((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.publicKey;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.authInfo);
        v.add(this.publicKey);
        return new DERSequence(v);
    }
}

