/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.dvcs;

import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cmp.PKIStatusInfo;
import kz.gamma.asn1.dvcs.DVCSCertInfo;
import kz.gamma.asn1.dvcs.DVCSRequestInformation;
import kz.gamma.asn1.dvcs.DVCSTime;
import kz.gamma.asn1.dvcs.TargetEtcChain;
import kz.gamma.asn1.x509.DigestInfo;
import kz.gamma.asn1.x509.Extensions;
import kz.gamma.asn1.x509.PolicyInformation;

public class DVCSCertInfoBuilder {
    private int version = 1;
    private DVCSRequestInformation dvReqInfo;
    private DigestInfo messageImprint;
    private DERInteger serialNumber;
    private DVCSTime responseTime;
    private PKIStatusInfo dvStatus;
    private PolicyInformation policy;
    private ASN1Set reqSignature;
    private ASN1Sequence certs;
    private Extensions extensions;
    private static final int DEFAULT_VERSION = 1;
    private static final int TAG_DV_STATUS = 0;
    private static final int TAG_POLICY = 1;
    private static final int TAG_REQ_SIGNATURE = 2;
    private static final int TAG_CERTS = 3;

    public DVCSCertInfoBuilder(DVCSRequestInformation dvReqInfo, DigestInfo messageImprint, DERInteger serialNumber, DVCSTime responseTime) {
        this.dvReqInfo = dvReqInfo;
        this.messageImprint = messageImprint;
        this.serialNumber = serialNumber;
        this.responseTime = responseTime;
    }

    public DVCSCertInfo build() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.version != 1) {
            v.add(new DERInteger(this.version));
        }
        v.add(this.dvReqInfo);
        v.add(this.messageImprint);
        v.add(this.serialNumber);
        v.add(this.responseTime);
        if (this.dvStatus != null) {
            v.add(new DERTaggedObject(false, 0, this.dvStatus));
        }
        if (this.policy != null) {
            v.add(new DERTaggedObject(false, 1, this.policy));
        }
        if (this.reqSignature != null) {
            v.add(new DERTaggedObject(false, 2, this.reqSignature));
        }
        if (this.certs != null) {
            v.add(new DERTaggedObject(false, 3, this.certs));
        }
        if (this.extensions != null) {
            v.add(this.extensions);
        }
        return DVCSCertInfo.getInstance(new DERSequence(v));
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDvReqInfo(DVCSRequestInformation dvReqInfo) {
        this.dvReqInfo = dvReqInfo;
    }

    public void setMessageImprint(DigestInfo messageImprint) {
        this.messageImprint = messageImprint;
    }

    public void setSerialNumber(DERInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setResponseTime(DVCSTime responseTime) {
        this.responseTime = responseTime;
    }

    public void setDvStatus(PKIStatusInfo dvStatus) {
        this.dvStatus = dvStatus;
    }

    public void setPolicy(PolicyInformation policy) {
        this.policy = policy;
    }

    public void setReqSignature(ASN1Set reqSignature) {
        this.reqSignature = reqSignature;
    }

    public void setCerts(TargetEtcChain[] certs) {
        this.certs = new DERSequence(certs);
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }
}

