/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.dvcs;

import java.util.Date;
import kz.gamma.asn1.ASN1Choice;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.cms.ContentInfo;

public class DVCSTime
extends ASN1Encodable
implements ASN1Choice {
    private DERGeneralizedTime genTime;
    private ContentInfo timeStampToken;
    private Date time;

    public DVCSTime(Date time) {
        this(new DERGeneralizedTime(time));
    }

    public DVCSTime(DERGeneralizedTime genTime) {
        this.genTime = genTime;
    }

    public DVCSTime(ContentInfo timeStampToken) {
        this.timeStampToken = timeStampToken;
    }

    public static DVCSTime getInstance(Object obj) {
        if (obj instanceof DVCSTime) {
            return (DVCSTime)obj;
        }
        if (obj instanceof DERGeneralizedTime) {
            return new DVCSTime(DERGeneralizedTime.getInstance(obj));
        }
        if (obj != null) {
            return new DVCSTime(ContentInfo.getInstance(obj));
        }
        return null;
    }

    public static DVCSTime getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DVCSTime.getInstance(obj.getObject());
    }

    public DERGeneralizedTime getGenTime() {
        return this.genTime;
    }

    public ContentInfo getTimeStampToken() {
        return this.timeStampToken;
    }

    @Override
    public DERObject toASN1Object() {
        if (this.genTime != null) {
            return this.genTime;
        }
        if (this.timeStampToken != null) {
            return this.timeStampToken.toASN1Object();
        }
        return null;
    }

    public String toString() {
        if (this.genTime != null) {
            return this.genTime.toString();
        }
        if (this.timeStampToken != null) {
            return this.timeStampToken.toString();
        }
        return null;
    }
}

