/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.dvcs;

import java.math.BigInteger;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREnumerated;
import kz.gamma.asn1.DERObject;

public class ServiceType
extends ASN1Encodable {
    public static final ServiceType CPD = new ServiceType(1);
    public static final ServiceType VSD = new ServiceType(2);
    public static final ServiceType VPKC = new ServiceType(3);
    public static final ServiceType CCPD = new ServiceType(4);
    private DEREnumerated value;

    public ServiceType(int value) {
        this.value = new DEREnumerated(value);
    }

    private ServiceType(DEREnumerated value) {
        this.value = value;
    }

    public static ServiceType getInstance(Object obj) {
        if (obj instanceof ServiceType) {
            return (ServiceType)obj;
        }
        if (obj != null) {
            return new ServiceType(DEREnumerated.getInstance(obj));
        }
        return null;
    }

    public static ServiceType getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ServiceType.getInstance(DEREnumerated.getInstance(obj, explicit));
    }

    public BigInteger getValue() {
        return this.value.getValue();
    }

    @Override
    public DERObject toASN1Object() {
        return this.value;
    }

    public String toString() {
        int num = this.value.getValue().intValue();
        return "" + num + (num == CPD.getValue().intValue() ? "(CPD)" : (num == VSD.getValue().intValue() ? "(VSD)" : (num == VPKC.getValue().intValue() ? "(VPKC)" : (num == CCPD.getValue().intValue() ? "(CCPD)" : "?"))));
    }
}

