/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.util;

import java.util.Enumeration;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.BERConstructedOctetString;
import kz.gamma.asn1.BERConstructedSequence;
import kz.gamma.asn1.BERSequence;
import kz.gamma.asn1.BERSet;
import kz.gamma.asn1.BERTaggedObject;
import kz.gamma.asn1.DERBMPString;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DERBoolean;
import kz.gamma.asn1.DERConstructedSequence;
import kz.gamma.asn1.DERConstructedSet;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERIA5String;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERPrintableString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERT61String;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.DERUTCTime;
import kz.gamma.asn1.DERUTF8String;
import kz.gamma.asn1.DERUnknownTag;
import kz.gamma.asn1.DERVisibleString;
import kz.gamma.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";

    static String _dumpAsString(String indent, DERObject obj) {
        if (obj instanceof ASN1Sequence) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Sequence)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            if (obj instanceof BERConstructedSequence) {
                buf.append("BER ConstructedSequence");
            } else if (obj instanceof DERConstructedSequence) {
                buf.append("DER ConstructedSequence");
            } else if (obj instanceof BERSequence) {
                buf.append("BER Sequence");
            } else if (obj instanceof DERSequence) {
                buf.append("DER Sequence");
            } else {
                buf.append("Sequence");
            }
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null || o.equals(new DERNull())) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERTaggedObject) {
            StringBuffer buf = new StringBuffer();
            String tab = indent + TAB;
            buf.append(indent);
            if (obj instanceof BERTaggedObject) {
                buf.append("BER Tagged [");
            } else {
                buf.append("Tagged [");
            }
            DERTaggedObject o = (DERTaggedObject)obj;
            buf.append(Integer.toString(o.getTagNo()));
            buf.append(']');
            if (!o.isExplicit()) {
                buf.append(" IMPLICIT ");
            }
            buf.append(System.getProperty("line.separator"));
            if (o.isEmpty()) {
                buf.append(tab);
                buf.append("EMPTY");
                buf.append(System.getProperty("line.separator"));
            } else {
                buf.append(ASN1Dump._dumpAsString(tab, o.getObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERConstructedSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("ConstructedSet");
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof BERSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("BER Set");
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("DER Set");
            buf.append(System.getProperty("line.separator"));
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(System.getProperty("line.separator"));
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERObjectIdentifier) {
            return indent + "ObjectIdentifier(" + ((DERObjectIdentifier)obj).getId() + ")" + System.getProperty("line.separator");
        }
        if (obj instanceof DERBoolean) {
            return indent + "Boolean(" + ((DERBoolean)obj).isTrue() + ")" + System.getProperty("line.separator");
        }
        if (obj instanceof DERInteger) {
            return indent + "Integer(" + ((DERInteger)obj).getValue() + ")" + System.getProperty("line.separator");
        }
        if (obj instanceof BERConstructedOctetString) {
            return indent + "BER Constructed Octet String[" + ((ASN1OctetString)obj).getOctets().length + "] " + System.getProperty("line.separator");
        }
        if (obj instanceof DEROctetString) {
            return indent + "DER Octet String[" + ((ASN1OctetString)obj).getOctets().length + "] " + System.getProperty("line.separator");
        }
        if (obj instanceof DERBitString) {
            return indent + "DER Bit String[" + ((DERBitString)obj).getBytes().length + ", " + ((DERBitString)obj).getPadBits() + "] " + System.getProperty("line.separator");
        }
        if (obj instanceof DERIA5String) {
            return indent + "IA5String(" + ((DERIA5String)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERUTF8String) {
            return indent + "UTF8String(" + ((DERUTF8String)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERPrintableString) {
            return indent + "PrintableString(" + ((DERPrintableString)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERVisibleString) {
            return indent + "VisibleString(" + ((DERVisibleString)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERBMPString) {
            return indent + "BMPString(" + ((DERBMPString)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERT61String) {
            return indent + "T61String(" + ((DERT61String)obj).getString() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERUTCTime) {
            return indent + "UTCTime(" + ((DERUTCTime)obj).getTime() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERGeneralizedTime) {
            return indent + "GeneralizedTime(" + ((DERGeneralizedTime)obj).getTime() + ") " + System.getProperty("line.separator");
        }
        if (obj instanceof DERUnknownTag) {
            return indent + "Unknown " + Integer.toString(((DERUnknownTag)obj).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)obj).getData())) + System.getProperty("line.separator");
        }
        return indent + obj.toString() + System.getProperty("line.separator");
    }

    public static String dumpAsString(Object obj) {
        if (obj instanceof DERObject) {
            return ASN1Dump._dumpAsString("", (DERObject)obj);
        }
        if (obj instanceof DEREncodable) {
            return ASN1Dump._dumpAsString("", ((DEREncodable)obj).getDERObject());
        }
        return "unknown object type " + obj.toString();
    }
}

