/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.x509;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.x500.X500Name;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.asn1.x509.TBSCertificate;
import kz.gamma.asn1.x509.Time;

public class Certificate
extends ASN1Encodable {
    ASN1Sequence seq;
    TBSCertificate tbsCert;
    AlgorithmIdentifier sigAlgId;
    DERBitString sig;

    public static Certificate getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Certificate.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Certificate getInstance(Object obj) {
        if (obj instanceof Certificate) {
            return (Certificate)obj;
        }
        if (obj != null) {
            return new Certificate(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Certificate(ASN1Sequence seq) {
        this.seq = seq;
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for a certificate");
        }
        this.tbsCert = TBSCertificate.getInstance(seq.getObjectAt(0));
        this.sigAlgId = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.sig = DERBitString.getInstance(seq.getObjectAt(2));
    }

    public TBSCertificate getTBSCertificate() {
        return this.tbsCert;
    }

    public DERInteger getVersion() {
        return this.tbsCert.getVersion();
    }

    public int getVersionNumber() {
        return this.tbsCert.getVersionNumber();
    }

    public DERInteger getSerialNumber() {
        return this.tbsCert.getSerialNumber();
    }

    public X500Name getIssuer() {
        return this.tbsCert.getIssuer();
    }

    public Time getStartDate() {
        return this.tbsCert.getStartDate();
    }

    public Time getEndDate() {
        return this.tbsCert.getEndDate();
    }

    public X500Name getSubject() {
        return this.tbsCert.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.tbsCert.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public DERBitString getSignature() {
        return this.sig;
    }

    @Override
    public DERObject toASN1Object() {
        return this.seq;
    }
}

