/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.Extension;

public class Extensions
extends ASN1Encodable {
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    public static Extensions getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Extensions.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Extensions getInstance(Object obj) {
        if (obj instanceof Extensions) {
            return (Extensions)obj;
        }
        if (obj != null) {
            return new Extensions(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Extensions(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            Extension ext = Extension.getInstance(e.nextElement());
            this.extensions.put(ext.getExtnId(), ext);
            this.ordering.addElement(ext.getExtnId());
        }
    }

    public Extensions(Extension extension) {
        this.ordering.addElement(extension.getExtnId());
        this.extensions.put(extension.getExtnId(), extension);
    }

    public Extensions(Extension[] extensions) {
        for (int i = 0; i != extensions.length; ++i) {
            Extension ext = extensions[i];
            this.ordering.addElement(ext.getExtnId());
            this.extensions.put(ext.getExtnId(), ext);
        }
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public Extension getExtension(DERObjectIdentifier oid) {
        return (Extension)this.extensions.get(oid);
    }

    public ASN1Encodable getExtensionParsedValue(DERObjectIdentifier oid) {
        Extension ext = this.getExtension(oid);
        if (ext != null) {
            return ext.getParsedValue();
        }
        return null;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            Extension ext = (Extension)this.extensions.get(oid);
            vec.add(ext);
        }
        return new DERSequence(vec);
    }

    public boolean equivalent(Extensions other) {
        if (this.extensions.size() != other.extensions.size()) {
            return false;
        }
        Enumeration e1 = this.extensions.keys();
        while (e1.hasMoreElements()) {
            Object key = e1.nextElement();
            if (this.extensions.get(key).equals(other.extensions.get(key))) continue;
            return false;
        }
        return true;
    }

    public DERObjectIdentifier[] getExtensionOIDs() {
        return this.toOidArray(this.ordering);
    }

    public DERObjectIdentifier[] getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public DERObjectIdentifier[] getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    private DERObjectIdentifier[] getExtensionOIDs(boolean isCritical) {
        Vector oidVec = new Vector();
        for (int i = 0; i != this.ordering.size(); ++i) {
            Object oid = this.ordering.elementAt(i);
            if (((Extension)this.extensions.get(oid)).isCritical() != isCritical) continue;
            oidVec.addElement(oid);
        }
        return this.toOidArray(oidVec);
    }

    private DERObjectIdentifier[] toOidArray(Vector oidVec) {
        DERObjectIdentifier[] oids = new DERObjectIdentifier[oidVec.size()];
        for (int i = 0; i != oids.length; ++i) {
            oids[i] = (DERObjectIdentifier)oidVec.elementAt(i);
        }
        return oids;
    }
}

