/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.x509;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.asn1.x509.X509Extension;

public class SubjectKeyIdentifier
extends ASN1Encodable {
    private byte[] keyidentifier;

    public static SubjectKeyIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SubjectKeyIdentifier.getInstance(ASN1OctetString.getInstance(obj, explicit));
    }

    public static SubjectKeyIdentifier getInstance(Object obj) {
        if (obj instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)obj;
        }
        if (obj instanceof SubjectPublicKeyInfo) {
            return new SubjectKeyIdentifier((SubjectPublicKeyInfo)obj);
        }
        if (obj instanceof ASN1OctetString) {
            return new SubjectKeyIdentifier((ASN1OctetString)obj);
        }
        if (obj instanceof X509Extension) {
            return SubjectKeyIdentifier.getInstance(X509Extension.convertValueToObject((X509Extension)obj));
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier: " + obj.getClass().getName());
    }

    public SubjectKeyIdentifier(byte[] keyid) {
        this.keyidentifier = keyid;
    }

    public SubjectKeyIdentifier(ASN1OctetString keyid) {
        this.keyidentifier = keyid.getOctets();
    }

    public SubjectKeyIdentifier(SubjectPublicKeyInfo spki) {
    }

    public byte[] getKeyIdentifier() {
        return this.keyidentifier;
    }

    @Override
    public DERObject toASN1Object() {
        return new DEROctetString(this.keyidentifier);
    }
}

