/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERTaggedObject;

public class AdminSecretInfo {
    public byte[] createAddBody(Map params) throws UnsupportedEncodingException {
        String trustName;
        String displayName;
        String telephoneNumber;
        Date birthDate;
        String country;
        String state;
        String city;
        String organization;
        String commonName;
        String uidInDn;
        StringBuilder dn = new StringBuilder();
        String mail = (String)params.get("mail");
        if (mail != null && mail.trim().length() > 0) {
            dn.append("E=").append(mail).append(";");
        }
        if ((uidInDn = (String)params.get("uidInDn")) != null && uidInDn.trim().length() > 0) {
            dn.append("UID=").append(uidInDn).append(";");
        }
        if ((commonName = (String)params.get("commonName")) == null || commonName.trim().length() == 0) {
            throw new NullPointerException("commonName is required");
        }
        dn.append("CN=").append(commonName).append(";");
        String organizationalUnit = (String)params.get("organizationalUnit");
        if (organizationalUnit != null && organizationalUnit.trim().length() > 0) {
            dn.append("OU=").append(organizationalUnit).append(";");
        }
        if ((organization = (String)params.get("organization")) != null && organization.trim().length() > 0) {
            dn.append("O=").append(organization).append(";");
        }
        if ((city = (String)params.get("city")) != null && city.trim().length() > 0) {
            dn.append("L=").append(city).append(";");
        }
        if ((state = (String)params.get("state")) != null && state.trim().length() > 0) {
            dn.append("ST=").append(state).append(";");
        }
        if ((country = (String)params.get("country")) == null || country.trim().length() == 0) {
            throw new NullPointerException("country is required");
        }
        dn.append("C=").append(country).append(";");
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        if (dn.toString().length() > 0) {
            rootVector.add(new DERTaggedObject(false, 0, new DEROctetString(dn.toString().getBytes("cp1251"))));
        }
        ASN1EncodableVector vectorAttributes = new ASN1EncodableVector();
        ASN1EncodableVector userNameVector = new ASN1EncodableVector();
        DEROctetString userNameDescription = new DEROctetString("userName".getBytes());
        userNameVector.add(userNameDescription);
        DEROctetString userNameValue = new DEROctetString(dn.toString().getBytes());
        DERSet userNameSet = new DERSet(userNameValue);
        userNameVector.add(userNameSet);
        vectorAttributes.add(new DERSequence(userNameVector));
        String uid = (String)params.get("uid");
        if (uid == null || uid.trim().length() == 0) {
            throw new NullPointerException("uid is required");
        }
        ASN1EncodableVector uidVector = new ASN1EncodableVector();
        DEROctetString uidDescription = new DEROctetString("uid".getBytes());
        uidVector.add(uidDescription);
        DEROctetString uidValue = new DEROctetString(uid.getBytes());
        DERSet uidSet = new DERSet(uidValue);
        uidVector.add(uidSet);
        vectorAttributes.add(new DERSequence(uidVector));
        String userPassword = (String)params.get("userPassword");
        if (userPassword == null || userPassword.trim().length() == 0) {
            throw new NullPointerException("userPassword is required");
        }
        ASN1EncodableVector userPasswordVector = new ASN1EncodableVector();
        DEROctetString userPasswordDescription = new DEROctetString("userPassword".getBytes());
        userPasswordVector.add(userPasswordDescription);
        DEROctetString userPasswordValue = new DEROctetString(userPassword.getBytes());
        DERSet userPasswordSet = new DERSet(userPasswordValue);
        userPasswordVector.add(userPasswordSet);
        vectorAttributes.add(new DERSequence(userPasswordVector));
        Boolean userState = (Boolean)params.get("userState");
        if (userState != null) {
            ASN1EncodableVector userStateVector = new ASN1EncodableVector();
            DEROctetString userStateDescription = new DEROctetString("userState".getBytes());
            userStateVector.add(userStateDescription);
            DEROctetString userStateValue = null;
            userStateValue = userState != false ? new DEROctetString("1".getBytes()) : new DEROctetString("0".getBytes());
            DERSet userStateSet = new DERSet(userStateValue);
            userStateVector.add(userStateSet);
            vectorAttributes.add(new DERSequence(userStateVector));
        }
        if ((birthDate = (Date)params.get("birthDate")) != null) {
            ASN1EncodableVector birthDateVector = new ASN1EncodableVector();
            DEROctetString birthDateDescription = new DEROctetString("birthDate".getBytes());
            birthDateVector.add(birthDateDescription);
            DERGeneralizedTime genTime = new DERGeneralizedTime(birthDate);
            DEROctetString birthDateValue = new DEROctetString(genTime.getTimeString().getBytes());
            DERSet birthDateSet = new DERSet(birthDateValue);
            birthDateVector.add(birthDateSet);
            vectorAttributes.add(new DERSequence(birthDateVector));
        }
        if ((telephoneNumber = (String)params.get("telephoneNumber")) != null && telephoneNumber.trim().length() > 0) {
            ASN1EncodableVector telephoneNumberVector = new ASN1EncodableVector();
            DEROctetString telephoneNumberDescription = new DEROctetString("telephoneNumber".getBytes());
            telephoneNumberVector.add(telephoneNumberDescription);
            DEROctetString telephoneNumberValue = new DEROctetString(telephoneNumber.getBytes());
            DERSet telephoneNumberSet = new DERSet(telephoneNumberValue);
            telephoneNumberVector.add(telephoneNumberSet);
            vectorAttributes.add(new DERSequence(telephoneNumberVector));
        }
        if (mail != null && mail.trim().length() > 0) {
            ASN1EncodableVector mailVector = new ASN1EncodableVector();
            DEROctetString mailDescription = new DEROctetString("mail".getBytes());
            mailVector.add(mailDescription);
            DEROctetString mailValue = new DEROctetString(mail.getBytes());
            DERSet mailSet = new DERSet(mailValue);
            mailVector.add(mailSet);
            vectorAttributes.add(new DERSequence(mailVector));
        }
        if ((displayName = (String)params.get("displayName")) != null && displayName.trim().length() > 0) {
            ASN1EncodableVector displayNameVector = new ASN1EncodableVector();
            DEROctetString displayNameDescription = new DEROctetString("displayName".getBytes());
            displayNameVector.add(displayNameDescription);
            DEROctetString displayNameValue = new DEROctetString(displayName.getBytes());
            DERSet displayNameSet = new DERSet(displayNameValue);
            displayNameVector.add(displayNameSet);
            vectorAttributes.add(new DERSequence(displayNameVector));
        }
        if ((trustName = (String)params.get("trustName")) != null && trustName.trim().length() > 0) {
            ASN1EncodableVector trustNameVector = new ASN1EncodableVector();
            DEROctetString trustNameDescription = new DEROctetString("trustName".getBytes());
            trustNameVector.add(trustNameDescription);
            DEROctetString trustNameValue = new DEROctetString(trustName.getBytes());
            DERSet trustNameSet = new DERSet(trustNameValue);
            trustNameVector.add(trustNameSet);
            vectorAttributes.add(new DERSequence(trustNameVector));
        }
        rootVector.add(new DERSequence(vectorAttributes));
        return new DERSequence(rootVector).getDEREncoded();
    }

    public byte[] createModBody(Map params) throws UnsupportedEncodingException {
        String trustName;
        String displayName;
        String mail;
        String telephoneNumber;
        Date birthDate;
        Boolean userState;
        String userPassword;
        String userName = (String)params.get("userName");
        if (userName == null || userName.trim().length() == 0) {
            throw new NullPointerException("userName is required");
        }
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        ASN1EncodableVector vectorAttributes = new ASN1EncodableVector();
        rootVector.add(new DERTaggedObject(false, 0, new DEROctetString(userName.getBytes("cp1251"))));
        String uid = (String)params.get("uid");
        if (uid != null && uid.trim().length() > 0) {
            ASN1EncodableVector uidVector = new ASN1EncodableVector();
            DEROctetString uidDescription = new DEROctetString("uid".getBytes());
            uidVector.add(uidDescription);
            DEROctetString uidValue = new DEROctetString(uid.getBytes());
            DERSet uidSet = new DERSet(uidValue);
            uidVector.add(uidSet);
            vectorAttributes.add(new DERSequence(uidVector));
        }
        if ((userPassword = (String)params.get("userPassword")) != null && userPassword.trim().length() > 0) {
            ASN1EncodableVector userPasswordVector = new ASN1EncodableVector();
            DEROctetString userPasswordDescription = new DEROctetString("userPassword".getBytes());
            userPasswordVector.add(userPasswordDescription);
            DEROctetString userPasswordValue = new DEROctetString(userPassword.getBytes());
            DERSet userPasswordSet = new DERSet(userPasswordValue);
            userPasswordVector.add(userPasswordSet);
            vectorAttributes.add(new DERSequence(userPasswordVector));
        }
        if ((userState = (Boolean)params.get("userState")) != null) {
            ASN1EncodableVector userStateVector = new ASN1EncodableVector();
            DEROctetString userStateDescription = new DEROctetString("userState".getBytes());
            userStateVector.add(userStateDescription);
            DEROctetString userStateValue = null;
            userStateValue = userState != false ? new DEROctetString("1".getBytes()) : new DEROctetString("0".getBytes());
            DERSet userStateSet = new DERSet(userStateValue);
            userStateVector.add(userStateSet);
            vectorAttributes.add(new DERSequence(userStateVector));
        }
        if ((birthDate = (Date)params.get("birthDate")) != null) {
            ASN1EncodableVector birthDateVector = new ASN1EncodableVector();
            DEROctetString birthDateDescription = new DEROctetString("birthDate".getBytes());
            birthDateVector.add(birthDateDescription);
            DERGeneralizedTime genTime = new DERGeneralizedTime(birthDate);
            DEROctetString birthDateValue = new DEROctetString(genTime.getTimeString().getBytes());
            DERSet birthDateSet = new DERSet(birthDateValue);
            birthDateVector.add(birthDateSet);
            vectorAttributes.add(new DERSequence(birthDateVector));
        }
        if ((telephoneNumber = (String)params.get("telephoneNumber")) != null && telephoneNumber.trim().length() > 0) {
            ASN1EncodableVector telephoneNumberVector = new ASN1EncodableVector();
            DEROctetString telephoneNumberDescription = new DEROctetString("telephoneNumber".getBytes());
            telephoneNumberVector.add(telephoneNumberDescription);
            DEROctetString telephoneNumberValue = new DEROctetString(telephoneNumber.getBytes());
            DERSet telephoneNumberSet = new DERSet(telephoneNumberValue);
            telephoneNumberVector.add(telephoneNumberSet);
            vectorAttributes.add(new DERSequence(telephoneNumberVector));
        }
        if ((mail = (String)params.get("mail")) != null && mail.trim().length() > 0) {
            ASN1EncodableVector mailVector = new ASN1EncodableVector();
            DEROctetString mailDescription = new DEROctetString("mail".getBytes());
            mailVector.add(mailDescription);
            DEROctetString mailValue = new DEROctetString(mail.getBytes());
            DERSet mailSet = new DERSet(mailValue);
            mailVector.add(mailSet);
            vectorAttributes.add(new DERSequence(mailVector));
        }
        if ((displayName = (String)params.get("displayName")) != null && displayName.trim().length() > 0) {
            ASN1EncodableVector displayNameVector = new ASN1EncodableVector();
            DEROctetString displayNameDescription = new DEROctetString("displayName".getBytes());
            displayNameVector.add(displayNameDescription);
            DEROctetString displayNameValue = new DEROctetString(displayName.getBytes());
            DERSet displayNameSet = new DERSet(displayNameValue);
            displayNameVector.add(displayNameSet);
            vectorAttributes.add(new DERSequence(displayNameVector));
        }
        if ((trustName = (String)params.get("trustName")) != null && trustName.trim().length() > 0) {
            ASN1EncodableVector trustNameVector = new ASN1EncodableVector();
            DEROctetString trustNameDescription = new DEROctetString("trustName".getBytes());
            trustNameVector.add(trustNameDescription);
            DEROctetString trustNameValue = new DEROctetString(trustName.getBytes());
            DERSet trustNameSet = new DERSet(trustNameValue);
            trustNameVector.add(trustNameSet);
            vectorAttributes.add(new DERSequence(trustNameVector));
        }
        rootVector.add(new DERSequence(vectorAttributes));
        return new DERSequence(rootVector).getDEREncoded();
    }

    public byte[] createDelBody(Map params) throws UnsupportedEncodingException {
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        String uid = (String)params.get("uid");
        if (uid != null && uid.trim().length() > 0) {
            rootVector.add(new DEROctetString(uid.getBytes()));
        } else {
            rootVector.add(new DEROctetString("".getBytes()));
        }
        String userName = (String)params.get("userName");
        if (userName == null || userName.trim().length() <= 0) {
            throw new NullPointerException("parameter userName is required");
        }
        rootVector.add(new DERTaggedObject(false, 1, new DEROctetString(userName.getBytes("cp1251"))));
        return new DERSequence(rootVector).getDEREncoded();
    }

    public byte[] createGetBody(Map params) throws UnsupportedEncodingException {
        String userName = (String)params.get("userName");
        if (userName == null || userName.trim().length() == 0) {
            throw new NullPointerException("userName is required");
        }
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        ASN1EncodableVector vectorAttributes = new ASN1EncodableVector();
        rootVector.add(new DERTaggedObject(false, 0, new DEROctetString(userName.getBytes("cp1251"))));
        DEROctetString uidDescription = new DEROctetString("uid".getBytes());
        vectorAttributes.add(uidDescription);
        DEROctetString userPasswordDescription = new DEROctetString("userPassword".getBytes());
        vectorAttributes.add(userPasswordDescription);
        DEROctetString userStateDescription = new DEROctetString("userState".getBytes());
        vectorAttributes.add(userStateDescription);
        DEROctetString birthDateDescription = new DEROctetString("birthDate".getBytes());
        vectorAttributes.add(birthDateDescription);
        DEROctetString telephoneNumberDescription = new DEROctetString("telephoneNumber".getBytes());
        vectorAttributes.add(telephoneNumberDescription);
        DEROctetString mailDescription = new DEROctetString("mail".getBytes());
        vectorAttributes.add(mailDescription);
        DEROctetString displayNameDescription = new DEROctetString("displayName".getBytes());
        vectorAttributes.add(displayNameDescription);
        DEROctetString trustNameDescription = new DEROctetString("trustName".getBytes());
        vectorAttributes.add(trustNameDescription);
        rootVector.add(new DERSequence(vectorAttributes));
        return new DERSequence(rootVector).getDEREncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map parseBody(byte[] body) throws IOException {
        ASN1InputStream in = null;
        try {
            in = new ASN1InputStream(body);
            DERSequence asnBody = (DERSequence)in.readObject();
            DERTaggedObject data = (DERTaggedObject)asnBody.getObjectAt(0);
            DEROctetString dataString = (DEROctetString)DEROctetString.getInstance(data);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            if (data.getTagNo() == 0) {
                resultMap.put("userName", new String(dataString.getOctets()));
            } else if (data.getTagNo() == 1) {
                resultMap.put("uid", new String(dataString.getOctets()));
            } else {
                throw new RuntimeException("Unknown tagNo value: " + data.getTagNo());
            }
            DERSequence attributesSequence = (DERSequence)asnBody.getObjectAt(1);
            Enumeration attributesEnum = attributesSequence.getObjects();
            while (attributesEnum.hasMoreElements()) {
                DERSequence element = (DERSequence)attributesEnum.nextElement();
                DERSet derSetValue = (DERSet)element.getObjectAt(1);
                if (derSetValue.size() <= 0) continue;
                DEROctetString octetStringDescription = (DEROctetString)element.getObjectAt(0);
                String description = new String(octetStringDescription.getOctets());
                DEROctetString octetStringValue = (DEROctetString)derSetValue.getObjectAt(0);
                if (description.equals("userState")) {
                    String userState = new String(octetStringValue.getOctets());
                    if (userState.equals("0")) {
                        resultMap.put(description, false);
                        continue;
                    }
                    resultMap.put(description, true);
                    continue;
                }
                if (description.equals("birthDate")) {
                    DERGeneralizedTime genTime = new DERGeneralizedTime(new String(octetStringValue.getOctets()));
                    try {
                        resultMap.put(description, genTime.getDate());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String value = new String(octetStringValue.getOctets());
                resultMap.put(description, value);
            }
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

