/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERUTCTime;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.cmp.CmpInfo;
import kz.gamma.tumarcsp.CertificateFieldsResolver;

public class BillingInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseBody(byte[] body) throws IOException {
        ASN1InputStream in = null;
        try {
            in = new ASN1InputStream(body);
            DERSequence asnBody = (DERSequence)in.readObject();
            Enumeration objects = asnBody.getObjects();
            ArrayList billingList = new ArrayList();
            while (objects.hasMoreElements()) {
                DERSequence billingItemAsn = (DERSequence)objects.nextElement();
                HashMap<String, Object> billingItem = new HashMap<String, Object>();
                DERInteger operType = (DERInteger)billingItemAsn.getObjectAt(0);
                billingItem.put("operType", operType.getValue().intValue());
                DERUTCTime operTime = (DERUTCTime)billingItemAsn.getObjectAt(1);
                try {
                    billingItem.put("operTime", operTime.getDate());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                DERObjectIdentifier service = (DERObjectIdentifier)billingItemAsn.getObjectAt(2);
                billingItem.put("service", service.getId());
                DEROctetString serialNumber = (DEROctetString)billingItemAsn.getObjectAt(3);
                CertificateFieldsResolver cfr = new CertificateFieldsResolver();
                String serNum = (String)cfr.getSerialNumber(new BigInteger(serialNumber.getOctets()), (Integer)0);
                billingItem.put("serialNumber", serNum);
                X509Name subject = X509Name.getInstance(billingItemAsn.getObjectAt(4));
                billingItem.put("subject", subject.toString());
                DERUTCTime notBefore = (DERUTCTime)billingItemAsn.getObjectAt(5);
                try {
                    billingItem.put("notBefore", notBefore.getDate());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                DERUTCTime notAfter = (DERUTCTime)billingItemAsn.getObjectAt(6);
                try {
                    billingItem.put("notAfter", notAfter.getDate());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                DERInteger keyUsage = (DERInteger)billingItemAsn.getObjectAt(7);
                billingItem.put("keyUsage", CmpInfo.keyUsageToString(keyUsage.getPositiveValue().intValue()));
                DERObjectIdentifier keyOID = (DERObjectIdentifier)billingItemAsn.getObjectAt(8);
                billingItem.put("keyOID", keyOID.getId());
                DERSequence policyList = (DERSequence)billingItemAsn.getObjectAt(9);
                Enumeration enumPolicy = policyList.getObjects();
                StringBuffer policies = new StringBuffer();
                while (enumPolicy.hasMoreElements()) {
                    DERObjectIdentifier policy = (DERObjectIdentifier)enumPolicy.nextElement();
                    policies.append(policy.getId()).append(", ");
                }
                if (policies.length() > 0) {
                    policies = policies.delete(policies.length() - 2, policies.length());
                }
                billingItem.put("policyList", policies);
                if (operType.getValue().intValue() == 1) {
                    DERInteger reason = (DERInteger)billingItemAsn.getObjectAt(10);
                    billingItem.put("reason", reason.getValue().intValue());
                }
                billingList.add(billingItem);
            }
            ArrayList arrayList = billingList;
            return arrayList;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

