/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class CMPEncrypt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] Encrypt(X509Certificate[] resp_certs, byte[] data, boolean includeData, int alg_id) throws CertificateEncodingException {
        byte[] res;
        Number hProv = 0;
        Number hKey = 0;
        Number[] hExpKeys = new Number[resp_certs.length];
        try {
            hProv = TumarCspFunctions.cpAcquireContext("", -268435456);
            for (int i = 0; i < resp_certs.length; ++i) {
                byte[] certEncoded = resp_certs[i].getEncoded();
                hExpKeys[i] = TumarCspFunctions.cpImportKey(hProv, certEncoded, certEncoded.length, 0, 0);
            }
            hKey = TumarCspFunctions.cpGenKey(hProv, alg_id, 1);
            byte[] enc_data = TumarCspFunctions.cpEncrypt(hProv, hKey, 0, 1, 0, data, data.length, data.length);
            if (includeData) {
                byte[] sizeBytes = UtilCM.intToByte(enc_data.length, 0);
                TumarCspFunctions.cpSetKeyParam(hProv, hKey, 110, sizeBytes, 0);
                TumarCspFunctions.cpSetKeyParam(hProv, hKey, 111, enc_data, 0);
            }
            TumarCspFunctions.cpSetKeyParam(hProv, hKey, 112, "1.2.840.113549.1.7.2".getBytes(), 0);
            int size = TumarCspFunctions.cpExportKeyDataSize(hProv, hKey, hExpKeys[resp_certs.length - 1], 80, 0x2000000);
            res = TumarCspFunctions.cpExportKeyDataEx(hProv, hKey, 0, 80, 0, size);
        }
        finally {
            try {
                TumarCspFunctions.cpDestroyKey(hProv, hKey);
            }
            catch (Exception exception) {}
            for (Number hExpKey : hExpKeys) {
                try {
                    TumarCspFunctions.cpDestroyKey(hProv, hExpKey);
                }
                catch (Exception exception) {}
            }
            try {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
            catch (Exception exception) {}
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] Decrypt(String profile, byte[] data) {
        byte[] res = null;
        Number hProv = 0;
        Number hKey = 0;
        try {
            hProv = TumarCspFunctions.cpAcquireContext(profile, 0);
            hKey = TumarCspFunctions.cpImportKey(hProv, data, data.length, 0, 0);
            byte[] len2 = TumarCspFunctions.cpGetKeyParamData(hProv, hKey, 110, 0);
            int len_temp = UtilCM.byteToInt(len2, 0, 1);
            if (len_temp != 0) {
                byte[] inc_data = TumarCspFunctions.cpGetKeyParamData(hProv, hKey, 111, 0);
                res = TumarCspFunctions.cpDecrypt(hProv, hKey, 0, 1, 0, inc_data, len_temp);
            }
        }
        finally {
            try {
                TumarCspFunctions.cpDestroyKey(hProv, hKey);
            }
            catch (Exception exception) {}
            try {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
            catch (Exception exception) {}
        }
        return res;
    }
}

