/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Date;
import java.util.Map;
import kz.gamma.cmp.CmpResponse;
import kz.gamma.core.UtilCM;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class CertificationResponse
extends CmpResponse {
    private Date time;
    private int status;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean verify(Map params) {
        byte[] serverCert = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 26, 0);
        this.handleKey2 = TumarCspFunctions.cpImportKey(this.handleProv, serverCert, serverCert.length, 0, 0);
        TumarCspFunctions.cpVerifySignature(this.handleProv, 0, this.response, this.response.length, this.handleKey2, "", 0x8000000);
        if (this.responseTypeCode != 3) throw new RuntimeCryptoException("Unknown certification response type: " + this.responseTypeCode);
        byte[] statusBytes = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 77, 0);
        this.status = UtilCM.byteToInt(statusBytes, 0, 1);
        if (this.status == 3) {
            try {
                byte[] timeBytes = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 78, 0);
                DateUtils dateUtils = DateUtils.getInstance();
                this.time = dateUtils.stringToDate(new String(timeBytes));
                return true;
            }
            catch (Exception e) {
                this.time = null;
            }
            return true;
        } else {
            if (this.status != 0 && this.status != 1) return false;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 26, this.response, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 68, this.response, 0);
        }
        return true;
    }

    private Date getTime() {
        return this.time;
    }

    public int getStatus() {
        return this.status;
    }
}

