/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.cmp.CmpData;
import kz.gamma.cmp.CmpInfo;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;

public abstract class CmpResponse
extends CmpData {
    protected byte[] response;
    protected int responseTypeCode;
    protected String responseType;
    protected String errorCmpStatus;
    protected String errorCmpFail;
    protected byte[] signerCertificate;
    protected byte[] usefulData;

    public byte[] getResponse() {
        return this.response;
    }

    public int getResponseTypeCode() {
        return this.responseTypeCode;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getErrorCmpStatus() {
        return this.errorCmpStatus;
    }

    public String getErrorCmpFail() {
        return this.errorCmpFail;
    }

    public byte[] getSignerCertificate() {
        return this.signerCertificate;
    }

    public byte[] getUsefulData() {
        return this.usefulData;
    }

    @Override
    protected void initFields() {
        super.initFields();
        this.response = null;
        this.responseTypeCode = 0;
        this.responseType = null;
        this.errorCmpStatus = null;
        this.errorCmpFail = null;
        this.signerCertificate = null;
        this.usefulData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyResponse(Map params) {
        try {
            this.initFields();
            this.profile = (String)params.get("profile");
            if (this.profile == null || this.profile.trim().length() == 0) {
                throw new NullPointerException("parameter profile is required");
            }
            this.response = (byte[])params.get("response");
            if (this.response == null) {
                throw new NullPointerException("parameter response is required");
            }
            this.acquireContextFlag = (Integer)params.get("acquireContextFlag");
            if (this.acquireContextFlag == null) {
                throw new NullPointerException("parameter acquireContextFlag is required");
            }
            boolean profileChecking = ProfileParams.isProfile(this.profile);
            if (profileChecking) {
                try {
                    Boolean result = this.profileInfo.isProfileExists(this.profile);
                    if (!(result != null && result.booleanValue() || this.acquireContextFlag == -268435456)) {
                        this.profileCreator.createProfile(this.profile, "file", this.profile, "", this.fileHelper.getDefaultKeysPath(), "bin", 41041, 43578);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.profile = ProfileParams.getProfileName(this.profile, true);
            }
            this.handleProv = TumarCspFunctions.cpAcquireContext(this.profile, this.acquireContextFlag);
            if (!profileChecking) {
                String serialNumber = this.profileInfo.getDataFromUrl(this.profile, 1);
                try {
                    KeyParams keyParams = new KeyParams(this.handleProv);
                    Object[] algID = keyParams.getKeyAlgIDList();
                    CSPUtil cspUtil = new CSPUtil();
                    this.profileKeySpec = cspUtil.getTypeKey((Integer)algID[keyParams.getIndexSN(serialNumber)]);
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException("Cannot obtain key usage for key with serial number: " + serialNumber);
                }
            }
            this.handleKey1 = TumarCspFunctions.cpImportKey(this.handleProv, this.response, this.response.length, 0, 0);
            byte[] type = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 80, 0);
            this.responseTypeCode = UtilCM.byteToInt(type, 0, 1);
            this.responseType = CmpInfo.codeToResponseType(this.responseTypeCode);
            if (this.responseTypeCode == 23) {
                byte[] status = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 77, 0);
                int statusInt = UtilCM.byteToInt(status, 0, 1);
                this.errorCmpStatus = CmpInfo.codeToStatus(statusInt);
                try {
                    byte[] fail = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 75, 0);
                    int failInt = UtilCM.byteToInt(fail, 0, 1);
                    if (failInt != 255) {
                        this.errorCmpFail = CmpInfo.codeToFail(failInt);
                    }
                }
                catch (Exception e) {
                    this.errorCmpFail = null;
                }
                boolean e = false;
                return e;
            }
            byte[] transId = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 81, 0);
            this.transactionId = new String(transId);
            this.signerCertificate = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 26, 0);
            String userPassword = (String)params.get("userPassword");
            if (this.signerCertificate != null && (userPassword == null || userPassword.trim().length() == 0)) {
                Number hCaKey = null;
                try {
                    hCaKey = TumarCspFunctions.cpGetUserKey(this.handleProv, 2);
                    this.caCertificate = TumarCspFunctions.cpGetKeyParamData(this.handleProv, hCaKey, 68, 0);
                    if (this.caCertificate != null) {
                        TumarCspFunctions.cpVerifySignature(this.handleProv, 0, this.signerCertificate, this.signerCertificate.length, 0, null, 0x1000000);
                    }
                }
                catch (Exception e) {
                    this.caCertificate = null;
                }
                finally {
                    if (hCaKey.longValue() != 0L) {
                        TumarCspFunctions.cpDestroyKey(this.handleProv, hCaKey);
                    }
                }
                this.handleKey2 = TumarCspFunctions.cpImportKey(this.handleProv, this.signerCertificate, this.signerCertificate.length, 0, 0);
                TumarCspFunctions.cpVerifySignature(this.handleProv, 0, this.response, this.response.length, this.handleKey2, "", 0x8000000);
            }
            boolean bl = this.verify(params);
            return bl;
        }
        finally {
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey1);
            }
            if (this.handleKey2.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey2);
            }
            if (this.handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(this.handleProv, 0);
            }
        }
    }

    protected abstract boolean verify(Map var1);
}

