/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.cmp.CmpRequest;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class DepositionRequest
extends CmpRequest {
    private String otp;

    @Override
    protected byte[] create(Map params) {
        String uid = (String)params.get("uid");
        if (uid == null || uid.trim().length() == 0) {
            throw new NullPointerException("parameter uid is required");
        }
        String userPassword = (String)params.get("userPassword");
        if (userPassword == null || userPassword.trim().length() == 0) {
            throw new NullPointerException("parameter userPassword is required");
        }
        String tId = (String)params.get("transactionId");
        if (tId == null || tId.trim().length() == 0) {
            return this.generateOutRequest(this.serverCertificate, uid, userPassword);
        }
        return this.generateInRequest(this.serverCertificate, uid, userPassword, tId);
    }

    private byte[] generateOutRequest(byte[] serverCert, String uid, String userPassword) {
        this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
        this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 1);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 90, "1.3.6.1.5.5.7.4.50.1".getBytes(), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 84, UtilCM.intToByte(32772, LibraryWrapper.SUN_CPU_ENDIAN), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 85, UtilCM.intToByte(32811, LibraryWrapper.SUN_CPU_ENDIAN), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 86, uid.getBytes(), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 87, DataConverter.stringToByteArray(userPassword), 0);
        if (serverCert != null) {
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, serverCert, 0);
        }
        this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, this.handleKey1, this.handleKey2, 57, 0);
        byte[] otpByte = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey2, 99, 0);
        this.otp = new String(otpByte);
        return this.request;
    }

    private byte[] generateInRequest(byte[] serverCert, String uid, String userPassword, String tId) {
        this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 1);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 90, "1.3.6.1.5.5.7.4.50.2".getBytes(), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 81, DataConverter.stringToByteArray(tId), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 84, UtilCM.intToByte(32772, LibraryWrapper.SUN_CPU_ENDIAN), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 85, UtilCM.intToByte(32811, LibraryWrapper.SUN_CPU_ENDIAN), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 86, uid.getBytes(), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 87, DataConverter.stringToByteArray(userPassword), 0);
        if (serverCert != null) {
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, serverCert, 0);
        }
        this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, this.handleKey2, this.handleKey2, 57, 0);
        return this.request;
    }

    public String getOtp() {
        return this.otp;
    }
}

