/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kz.gamma.cmp.CmpResponse;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class DepositionResponse
extends CmpResponse {
    private Date time;

    @Override
    protected boolean verify(Map params) {
        this.response = (byte[])params.get("response");
        String userPassword = (String)params.get("userPassword");
        String otp = (String)params.get("otp");
        if (otp == null || otp.trim().length() == 0) {
            return this.verifyOutResponse(userPassword, this.response);
        }
        return this.verifyInResponse(userPassword, otp, this.response);
    }

    private boolean verifyOutResponse(String userPassword, byte[] response) {
        if (this.responseTypeCode == 22) {
            byte[] timeAsBytes = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 78, 0);
            try {
                this.time = DateUtils.getInstance().stringToDate(new String(timeAsBytes));
            }
            catch (ParseException e) {
                this.time = null;
            }
        } else {
            throw new RuntimeCryptoException("Unknown (out) deposition response type: " + this.responseTypeCode);
        }
        this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 87, DataConverter.stringToByteArray(userPassword), 0);
        TumarCspFunctions.cpVerifySignature(this.handleProv, 0, response, response.length, this.handleKey2, "", 0x8000000);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean verifyInResponse(String userPassword, String otp, byte[] response) {
        Number handleKey3 = 0;
        try {
            if (this.responseTypeCode == 22) {
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 90, DataConverter.stringToByteArray("1.3.6.1.5.5.7.4.50.2"), 0);
                if (this.handleKey2.longValue() != 0L) {
                    TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey2);
                }
            } else {
                throw new RuntimeCryptoException("Unknown (in) deposition response type: " + this.responseTypeCode);
            }
            this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 87, DataConverter.stringToByteArray(userPassword), 0);
            TumarCspFunctions.cpVerifySignature(this.handleProv, 0, response, response.length, this.handleKey2, "", 0x8000000);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 87, DataConverter.stringToByteArray(userPassword), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 99, DataConverter.stringToByteArray(otp), 0);
            byte[] keyContainer = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 92, 0);
            handleKey3 = TumarCspFunctions.cpImportKey(this.handleProv, keyContainer, keyContainer.length, 0, 1);
            Boolean bl = true;
            return bl;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, handleKey3);
            }
        }
    }

    public Date getTime() {
        return this.time;
    }
}

