/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.GeneralName;
import kz.gamma.asn1.x509.GeneralNames;
import kz.gamma.asn1.x509.X509Extension;
import kz.gamma.asn1.x509.X509Extensions;
import kz.gamma.cmp.CmpRequest;
import kz.gamma.core.UtilCM;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.profile.ProfileInfo;
import kz.gamma.util.DNVerifier;

public class InitialRegistrationRequest
extends CmpRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] create(Map params) {
        LinkedList<Number> hNewKeyList = new LinkedList<Number>();
        Number hProvLocal = 0;
        try {
            List subjectAltNameList;
            int i;
            String uid = (String)params.get("uid");
            if (uid == null || uid.trim().length() == 0) {
                throw new NullPointerException("parameter uid is required");
            }
            String userPassword = (String)params.get("userPassword");
            if (userPassword == null || userPassword.trim().length() == 0) {
                throw new NullPointerException("parameter userPassword is required");
            }
            List keyOidsList = (List)params.get("keyOidsList");
            boolean profileChecking = ProfileParams.isProfile(this.profile);
            if (!profileChecking) {
                throw new IllegalArgumentException("You cannot use url in initial registration request");
            }
            if (keyOidsList != null && (keyOidsList.size() <= 0 || keyOidsList.size() > 2)) {
                throw new IllegalArgumentException("Size of keyOidsList must be from 1 to 2");
            }
            this.profile = ProfileParams.getProfileName(this.profile, true);
            if (keyOidsList != null && keyOidsList.size() > 0 && keyOidsList.size() <= 2) {
                for (i = 0; i < keyOidsList.size(); ++i) {
                    Integer algId = GammaTechProvider.getAlgUtil().getAlgKey().get(keyOidsList.get(i));
                    Number hNewKey = TumarCspFunctions.cpGenKey(this.handleProv, algId, 1);
                    hNewKeyList.add(i, hNewKey);
                }
            } else if (profileChecking) {
                hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456);
                String url = TumarCspFunctions.cpUrlToNewUrl(this.profile, null, 1, hProvLocal);
                ProfileInfo profileInfo = new ProfileInfo();
                Integer algCodeOrAlgIdExch = Integer.valueOf(profileInfo.getDataFromUrl(url, 7));
                Object algIdExch = 0;
                if (GammaTechProvider.getAlgUtil().isAlgId(algCodeOrAlgIdExch).booleanValue()) {
                    algIdExch = algCodeOrAlgIdExch;
                } else if (GammaTechProvider.getAlgUtil().isAlgCode(algCodeOrAlgIdExch).booleanValue()) {
                    algIdExch = GammaTechProvider.getAlgUtil().getAlgId(algCodeOrAlgIdExch);
                } else {
                    String message = String.format("Number \"%d\" is not alg id or alg code", algCodeOrAlgIdExch);
                    throw new RuntimeException(message);
                }
                Integer algCodeOrAlgIdSign = Integer.valueOf(profileInfo.getDataFromUrl(url, 8));
                Integer algIdSign = 0;
                if (GammaTechProvider.getAlgUtil().isAlgId(algCodeOrAlgIdSign).booleanValue()) {
                    algIdSign = algCodeOrAlgIdSign;
                } else if (GammaTechProvider.getAlgUtil().isAlgCode(algCodeOrAlgIdSign).booleanValue()) {
                    algIdSign = GammaTechProvider.getAlgUtil().getAlgId(algCodeOrAlgIdSign);
                } else {
                    String message = String.format("Number \"%d\" is not alg id or alg code", algCodeOrAlgIdSign);
                    throw new RuntimeException(message);
                }
                Number hNewKeyExch = TumarCspFunctions.cpGenKey(this.handleProv, (Integer)algIdExch, 1);
                hNewKeyList.add(0, hNewKeyExch);
                Number hNewKeySign = TumarCspFunctions.cpGenKey(this.handleProv, algIdSign, 1);
                hNewKeyList.add(1, hNewKeySign);
            }
            this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 1);
            for (i = 1; i < hNewKeyList.size(); ++i) {
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 79, UtilCM.addressToByte((Number)hNewKeyList.get(i), LibraryWrapper.SUN_CPU_ENDIAN), 0);
            }
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 80, UtilCM.intToByte(0, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 84, UtilCM.intToByte(32772, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 85, UtilCM.intToByte(32811, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 86, uid.getBytes(), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 87, DataConverter.stringToByteArray(userPassword), 0);
            if (this.serverCertificate != null && this.serverCertificate.length > 0) {
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, this.serverCertificate, 0);
            }
            if ((subjectAltNameList = (List)params.get("subjectAltNameList")) != null && subjectAltNameList.size() > 0) {
                DNVerifier dnVerifier = new DNVerifier();
                ASN1EncodableVector generalNamesVector = new ASN1EncodableVector();
                for (String subjectAltName : subjectAltNameList) {
                    if (dnVerifier.isHaveIncorrectChar(subjectAltName).booleanValue()) {
                        throw new RuntimeException("DN contain incorrect symbols. Please, delete this symbols before Initialization Request creating. List of incorrect symbols: " + new String(DNVerifier.INCORRECT_CHARS_IN_GEN));
                    }
                    GeneralName generalName = new GeneralName(4, subjectAltName);
                    generalNamesVector.add(generalName);
                }
                GeneralNames subjectAltName = new GeneralNames(new DERSequence(generalNamesVector));
                X509Extension extension = new X509Extension(false, (ASN1OctetString)new DEROctetString(subjectAltName));
                Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
                Vector<X509Extension> values = new Vector<X509Extension>();
                oids.add(X509Extensions.SubjectAlternativeName);
                values.add(extension);
                X509Extensions extensions = new X509Extensions(oids, values);
                DERSequence derSequence = (DERSequence)extensions.toASN1Object();
                byte[] cmpExt = null;
                try {
                    cmpExt = derSequence.getObjectAt(0).getDERObject().getEncoded();
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot get extension. Exception message: " + e.getMessage());
                }
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 155, cmpExt, 0);
            }
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, (Number)hNewKeyList.get(0), this.handleKey2, 57, 0);
            return byArray;
        }
        finally {
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
            if (hNewKeyList != null && hNewKeyList.size() > 0) {
                for (Number hNewKey : hNewKeyList) {
                    if (hNewKey.longValue() == 0L) continue;
                    TumarCspFunctions.cpDestroyKey(this.handleProv, hNewKey);
                }
            }
        }
    }

    public String getExchangeCertificateSerialNumber() {
        throw new RuntimeException("Method is not implemented");
    }

    public String getSignCertificateSerialNumber() {
        throw new RuntimeException("Method is not implemented");
    }
}

