/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.cmp.CmpResponse;
import kz.gamma.core.UtilCM;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class InitialRegistrationResponse
extends CmpResponse {
    private Date time;
    private int status;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean verify(Map params) {
        String userPassword = (String)params.get("userPassword");
        if (userPassword == null || userPassword.trim().length() == 0) {
            throw new NullPointerException("parameter userPassword is required");
        }
        this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 1);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 87, DataConverter.stringToByteArray(userPassword), 0);
        TumarCspFunctions.cpVerifySignature(this.handleProv, 0, this.response, this.response.length, this.handleKey2, "", 0x8000000);
        if (this.responseTypeCode != 1) throw new RuntimeCryptoException("Unknown initial registration response type: " + this.responseTypeCode);
        byte[] statusBytes = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 77, 0);
        this.status = UtilCM.byteToInt(statusBytes, 0, 1);
        if (this.status == 3) {
            try {
                byte[] timeBytes = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 78, 0);
                DateUtils dateUtils = DateUtils.getInstance();
                this.time = dateUtils.stringToDate(new String(timeBytes));
                return true;
            }
            catch (Exception e) {
                this.time = null;
            }
            return true;
        } else {
            if (this.status != 0 && this.status != 1) return false;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 26, this.response, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 68, this.response, 0);
        }
        return true;
    }

    private Date getTime() {
        return this.time;
    }

    public int getStatus() {
        return this.status;
    }

    public void setResponse(byte[] response) {
        this.response = response;
    }

    public List<byte[]> getCertificates() {
        FilterInputStream in = null;
        ArrayList<byte[]> userCertificates = null;
        try {
            DERTaggedObject taggedObject1;
            userCertificates = new ArrayList<byte[]>();
            in = new ASN1InputStream(this.response);
            DERSequence asnBody = (DERSequence)((ASN1InputStream)in).readObject();
            DEREncodable element = asnBody.getObjectAt(1);
            if (element instanceof DERTaggedObject && ((taggedObject1 = (DERTaggedObject)element).getTagNo() == 1 || taggedObject1.getTagNo() == 3)) {
                DERSequence userCertificatesSequence = (DERSequence)((DERSequence)taggedObject1.getObject()).getObjectAt(1);
                Enumeration userCertificatesEnum = userCertificatesSequence.getObjects();
                while (userCertificatesEnum.hasMoreElements()) {
                    DERSequence object = (DERSequence)userCertificatesEnum.nextElement();
                    DERSequence cert = (DERSequence)((DERTaggedObject)((DERSequence)object.getObjectAt(2)).getObjectAt(0)).getObject();
                    userCertificates.add(cert.getDEREncoded());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Cannot get certificates from initial registration response");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return userCertificates;
    }
}

