/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import kz.gamma.cmp.CmpRequest;
import kz.gamma.core.UtilCM;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class KeyUpdateRequest
extends CmpRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] create(Map params) {
        LinkedList<Number> hNewKeyList = new LinkedList<Number>();
        try {
            Date notAfter = (Date)params.get("notAfter");
            if (notAfter == null) {
                throw new NullPointerException("parameter notAfter is required");
            }
            ArrayList<byte[]> userCertificates = (ArrayList<byte[]>)params.get("userCertificates");
            if (userCertificates != null) {
                if (userCertificates.size() != 1 && userCertificates.size() != 2) {
                    throw new IllegalArgumentException("Size of userCertificates must be from 1 to 2");
                }
            } else {
                byte[] userExchCertificate = (byte[])params.get("userExchCertificate");
                byte[] userSignCertificate = (byte[])params.get("userSignCertificate");
                if (userExchCertificate == null && userSignCertificate == null) {
                    throw new IllegalArgumentException("Parameter userExchCertificate or userSignCertificate is required");
                }
                userCertificates = new ArrayList<byte[]>();
                if (userExchCertificate != null) {
                    userCertificates.add(userExchCertificate);
                }
                if (userSignCertificate != null) {
                    userCertificates.add(userSignCertificate);
                }
            }
            byte[] dateInBytes = null;
            try {
                String stringDate = DateUtils.getInstance().dateToString(notAfter, "yyyyMMddHHmmss'Z'");
                dateInBytes = stringDate.getBytes("cp1251");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot format date to bytes");
            }
            this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 1);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 80, UtilCM.intToByte(7, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            byte[] dateType = new byte[]{48, 17, -127, 15};
            byte[] newDate = new byte[19];
            System.arraycopy(dateType, 0, newDate, 0, 4);
            System.arraycopy(dateInBytes, 0, newDate, 4, 15);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 154, newDate, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 88, UtilCM.addressToByte(this.handleKey1, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            if (this.serverCertificate != null && this.serverCertificate.length > 0) {
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, this.serverCertificate, 0);
            }
            for (int i = 0; i < userCertificates.size(); ++i) {
                Number hNewKey = TumarCspFunctions.cpImportKey(this.handleProv, (byte[])userCertificates.get(i), ((byte[])userCertificates.get(i)).length, 0, 0);
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 79, UtilCM.addressToByte(hNewKey, LibraryWrapper.SUN_CPU_ENDIAN), 0);
                hNewKeyList.add(i, hNewKey);
            }
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, (Number)0, this.handleKey2, 57, 0);
            return byArray;
        }
        finally {
            if (hNewKeyList != null && hNewKeyList.size() > 0) {
                for (Number hNewKey : hNewKeyList) {
                    if (hNewKey.longValue() == 0L) continue;
                    TumarCspFunctions.cpDestroyKey(this.handleProv, hNewKey);
                }
            }
        }
    }
}

