/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.profile.ProfileInfo;

public class OCSPRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createRequest(Map params) {
        Number handleProv = 0;
        Number handleExpKey = 0;
        Number handleKey = 0;
        try {
            String profile = (String)params.get("profile");
            if (profile == null || profile.trim().length() == 0) {
                throw new NullPointerException("parameter profile is required");
            }
            Integer keySpec = null;
            boolean profileChecking = ProfileParams.isProfile(profile);
            if (profileChecking) {
                keySpec = (Integer)params.get("keySpec");
                if (keySpec == null) {
                    keySpec = 2;
                }
                profile = ProfileParams.getProfileName(profile, true);
            }
            handleProv = TumarCspFunctions.cpAcquireContext(profile, 64);
            if (!profileChecking) {
                ProfileInfo profileInfo = new ProfileInfo();
                String serialNumber = profileInfo.getDataFromUrl(profile, 1);
                try {
                    KeyParams keyParams = new KeyParams(handleProv);
                    Object[] algID = keyParams.getKeyAlgIDList();
                    CSPUtil cspUtil = new CSPUtil();
                    keySpec = cspUtil.getTypeKey((Integer)algID[keyParams.getIndexSN(serialNumber)]);
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException("Cannot obtain key usage for key with serial number: " + serialNumber);
                }
            }
            handleExpKey = TumarCspFunctions.cpGetUserKey(handleProv, keySpec);
            byte[] cert = TumarCspFunctions.cpGetKeyParamData(handleProv, handleExpKey, 26, 0);
            handleKey = TumarCspFunctions.cpImportKey(handleProv, cert, cert.length, 0, 0);
            byte[] byArray = TumarCspFunctions.cpExportKeyData(handleProv, handleKey, handleExpKey, 65, 0);
            return byArray;
        }
        finally {
            if (handleKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(handleProv, handleKey);
            }
            if (handleExpKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(handleProv, handleExpKey);
            }
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(handleProv, 0);
            }
        }
    }
}

