/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class OCSPResponse {
    protected int status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyResponse(Map params) {
        Number handleProv = 0;
        Number handleKey = 0;
        try {
            String profile = (String)params.get("profile");
            if (profile == null || profile.trim().length() == 0) {
                throw new NullPointerException("parameter profile is required");
            }
            byte[] response = (byte[])params.get("response");
            if (ProfileParams.isProfile(profile)) {
                profile = ProfileParams.getProfileName(profile, true);
                if (response.length == 5) {
                    throw new RuntimeCryptoException("Bad response type");
                }
                profile = ProfileParams.getProfileName(profile, true);
            }
            handleProv = TumarCspFunctions.cpAcquireContext(profile, 64);
            handleKey = TumarCspFunctions.cpImportKey(handleProv, response, response.length, 0, 0);
            byte[] type = TumarCspFunctions.cpGetKeyParamData(handleProv, handleKey, 123, 0);
            this.status = UtilCM.byteToInt(type, 0, 1);
            byte[] cert = TumarCspFunctions.cpGetKeyParamData(handleProv, handleKey, 26, 0);
            if (handleKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(handleProv, handleKey);
            }
            handleKey = TumarCspFunctions.cpImportKey(handleProv, cert, cert.length, 0, 0);
            TumarCspFunctions.cpVerifySignature(handleProv, 0, response, response.length, handleKey, "", 0x10000000);
            boolean bl = this.status == 0;
            return bl;
        }
        finally {
            if (handleKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(handleProv, handleKey);
            }
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(handleProv, 0);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }
}

