/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.cmp.CmpRequest;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class SecretRequest
extends CmpRequest {
    public static final int ADD = 0;
    public static final int MOD = 1;
    public static final int GET = 2;
    public static final int DEL = 3;

    @Override
    protected byte[] create(Map params) {
        byte[] body = (byte[])params.get("body");
        if (body == null) {
            throw new NullPointerException("parameter body is required");
        }
        String secretOperationOid = (String)params.get("secretOperationOid");
        if (secretOperationOid == null || secretOperationOid.trim().length() == 0) {
            throw new NullPointerException("parameter secretOperationOid is required");
        }
        Integer operationType = (Integer)params.get("operationType");
        if (operationType == null) {
            throw new IllegalArgumentException("Operation type must not be null");
        }
        switch (operationType) {
            case 0: {
                return this.addSecretRequest(body, secretOperationOid);
            }
            case 1: {
                return this.modSecretRequest(body, secretOperationOid);
            }
            case 2: {
                if (secretOperationOid.equals("1.3.6.1.5.5.7.4.12")) {
                    throw new IllegalArgumentException("User cannot get own secret");
                }
                return this.getSecretRequest(body, secretOperationOid);
            }
            case 3: {
                if (secretOperationOid.equals("1.3.6.1.5.5.7.4.12")) {
                    return this.delSecretRequestUser(body, secretOperationOid);
                }
                return this.delSecretRequestAdmin(body, secretOperationOid);
            }
        }
        throw new IllegalArgumentException("Unknown operation type: " + operationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] addSecretRequest(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 90, secretOperationOid.getBytes(), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 88, UtilCM.addressToByte(this.handleKey1, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            if (this.serverCertificate == null || this.serverCertificate.length <= 0) {
                throw new NullPointerException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
            }
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, this.serverCertificate, 0);
            handleKey3 = TumarCspFunctions.cpImportKey(this.handleProv, this.serverCertificate, this.serverCertificate.length, 0, 0);
            byte[] algId = TumarCspFunctions.cpGetKeyParamData(this.handleProv, handleKey3, 7, 0);
            int algIdInt = UtilCM.byteToInt(algId, 0, 1);
            algIdInt = (algIdInt & 0x1FF) >= 80 ? 26115 : 26144;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGenKey(this.handleProv, algIdInt, 1);
            int dw = 1;
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 4, UtilCM.intToByte(dw, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            dw = 1;
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 3, UtilCM.intToByte(dw, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            byte[] encryptedData = TumarCspFunctions.cpEncrypt(this.handleProv, this.handleKey1, 0, 1, 0, body, body.length, body.length);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 110, UtilCM.intToByte(encryptedData.length, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 111, encryptedData, 0);
            int sz = TumarCspFunctions.cpExportKeyDataSize(this.handleProv, this.handleKey1, handleKey3, 80, 0x2000000);
            byte[] data = TumarCspFunctions.cpExportKeyDataEx(this.handleProv, this.handleKey1, 0, 80, 0x2000000, sz);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 91, data, 0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, this.handleKey1, this.handleKey2, 57, 0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, handleKey3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] modSecretRequest(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 90, secretOperationOid.getBytes(), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 88, UtilCM.addressToByte(this.handleKey1, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            if (this.serverCertificate == null || this.serverCertificate.length <= 0) {
                throw new NullPointerException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
            }
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, this.serverCertificate, 0);
            handleKey3 = TumarCspFunctions.cpImportKey(this.handleProv, this.serverCertificate, this.serverCertificate.length, 0, 0);
            byte[] algId = TumarCspFunctions.cpGetKeyParamData(this.handleProv, handleKey3, 7, 0);
            int algIdInt = UtilCM.byteToInt(algId, 0, 1);
            algIdInt = (algIdInt & 0x1FF) >= 80 ? 26115 : 26144;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGenKey(this.handleProv, algIdInt, 1);
            int dw = 1;
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 4, UtilCM.intToByte(dw, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            dw = 1;
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 3, UtilCM.intToByte(dw, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            byte[] encryptedData = TumarCspFunctions.cpEncrypt(this.handleProv, this.handleKey1, 0, 1, 0, body, body.length, body.length);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 110, UtilCM.intToByte(encryptedData.length, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 111, encryptedData, 0);
            int sz = TumarCspFunctions.cpExportKeyDataSize(this.handleProv, this.handleKey1, handleKey3, 80, 0x2000000);
            byte[] data = TumarCspFunctions.cpExportKeyDataEx(this.handleProv, this.handleKey1, 0, 80, 0x2000000, sz);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 91, data, 0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, this.handleKey1, this.handleKey2, 57, 0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, handleKey3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSecretRequest(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 90, secretOperationOid.getBytes(), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 88, UtilCM.addressToByte(this.handleKey1, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 91, body, 0);
            if (this.serverCertificate != null && this.serverCertificate.length > 0) {
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, this.serverCertificate, 0);
            }
            handleKey3 = TumarCspFunctions.cpGetUserKey(this.handleProv, 1);
            byte[] clientExchCert = TumarCspFunctions.cpGetKeyParamData(this.handleProv, handleKey3, 26, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 26, clientExchCert, 0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, this.handleKey1, this.handleKey2, 57, 0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, handleKey3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] delSecretRequestUser(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 90, secretOperationOid.getBytes(), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 88, UtilCM.addressToByte(this.handleKey1, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            if (this.serverCertificate == null || this.serverCertificate.length <= 0) {
                throw new NullPointerException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
            }
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, this.serverCertificate, 0);
            handleKey3 = TumarCspFunctions.cpImportKey(this.handleProv, this.serverCertificate, this.serverCertificate.length, 0, 0);
            byte[] algId = TumarCspFunctions.cpGetKeyParamData(this.handleProv, handleKey3, 7, 0);
            int algIdInt = UtilCM.byteToInt(algId, 0, 1);
            algIdInt = (algIdInt & 0x1FF) >= 80 ? 26115 : 26144;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGenKey(this.handleProv, algIdInt, 1);
            int dw = 1;
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 4, UtilCM.intToByte(dw, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            dw = 1;
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 3, UtilCM.intToByte(dw, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            byte[] encryptedData = TumarCspFunctions.cpEncrypt(this.handleProv, this.handleKey1, 0, 1, 0, body, body.length, body.length);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 110, UtilCM.intToByte(encryptedData.length, LibraryWrapper.SUN_CPU_ENDIAN), 0);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 111, encryptedData, 0);
            int sz = TumarCspFunctions.cpExportKeyDataSize(this.handleProv, this.handleKey1, handleKey3, 80, 0x2000000);
            byte[] data = TumarCspFunctions.cpExportKeyDataEx(this.handleProv, this.handleKey1, 0, 80, 0x2000000, sz);
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 91, data, 0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, this.handleKey1, this.handleKey2, 57, 0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.handleProv, handleKey3);
            }
        }
    }

    private byte[] delSecretRequestAdmin(byte[] body, String secretOperationOid) {
        this.handleKey1 = TumarCspFunctions.cpGetUserKey(this.handleProv, this.profileKeySpec);
        this.handleKey2 = TumarCspFunctions.cpGenKey(this.handleProv, 41050, 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 90, secretOperationOid.getBytes(), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 88, UtilCM.addressToByte(this.handleKey1, LibraryWrapper.SUN_CPU_ENDIAN), 0);
        TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 91, body, 0);
        if (this.serverCertificate != null && this.serverCertificate.length > 0) {
            TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey2, 89, this.serverCertificate, 0);
        }
        this.request = TumarCspFunctions.cpExportKeyData(this.handleProv, this.handleKey1, this.handleKey2, 57, 0);
        return this.request;
    }
}

