/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.cmp.CmpResponse;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class SecretResponse
extends CmpResponse {
    @Override
    protected boolean verify(Map params) {
        if (this.responseTypeCode != 22) {
            throw new RuntimeCryptoException("Unknown secret response type: " + this.responseTypeCode);
        }
        String secretOperationOid = (String)params.get("secretOperationOid");
        Integer operationType = (Integer)params.get("operationType");
        if (operationType == null) {
            throw new IllegalArgumentException("Operation type must not be null");
        }
        switch (operationType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                if (secretOperationOid == null || secretOperationOid.trim().length() == 0) {
                    throw new NullPointerException("parameter secretOperationOid is required");
                }
                TumarCspFunctions.cpSetKeyParam(this.handleProv, this.handleKey1, 90, secretOperationOid.getBytes(), 0);
                this.usefulData = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 91, 0);
                if (this.handleKey1.longValue() != 0L) {
                    TumarCspFunctions.cpDestroyKey(this.handleProv, this.handleKey1);
                }
                this.handleKey1 = TumarCspFunctions.cpImportKey(this.handleProv, this.usefulData, this.usefulData.length, 0, 0);
                byte[] pkcs7len = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 110, 0);
                int pkcs7lenInt = UtilCM.byteToInt(pkcs7len, 0, 1);
                if (pkcs7lenInt == 0) {
                    throw new RuntimeCryptoException("CMP_GENERAL_GET_USER_DETAILS. EnvelopedData size is 0");
                }
                byte[] pkcs7 = TumarCspFunctions.cpGetKeyParamData(this.handleProv, this.handleKey1, 111, 0);
                this.usefulData = TumarCspFunctions.cpDecrypt(this.handleProv, this.handleKey1, 0, 1, 0, pkcs7, pkcs7lenInt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type: " + operationType);
            }
        }
        return true;
    }
}

