/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.cmp.CmpInfo;

public class TransactionInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseBody(byte[] body) throws IOException {
        ASN1InputStream in = null;
        try {
            in = new ASN1InputStream(body);
            DERSequence asnBody = (DERSequence)in.readObject();
            Enumeration objects = asnBody.getObjects();
            ArrayList transactionList = new ArrayList();
            while (objects.hasMoreElements()) {
                DERSequence transaction = (DERSequence)objects.nextElement();
                Enumeration info = transaction.getObjects();
                HashMap<String, Object> transInfoMap = new HashMap<String, Object>();
                while (info.hasMoreElements()) {
                    Object transInfoAsn = info.nextElement();
                    if (transInfoAsn instanceof DEROctetString) {
                        DEROctetString transactionID = (DEROctetString)transInfoAsn;
                        transInfoMap.put("transactionId", new String(transactionID.getOctets()));
                        continue;
                    }
                    if (!(transInfoAsn instanceof DERTaggedObject)) continue;
                    DERTaggedObject data = (DERTaggedObject)transInfoAsn;
                    if (data.getTagNo() == 0) {
                        DERInteger type = DERInteger.getInstance(data);
                        transInfoMap.put("type", CmpInfo.transactionTypeToString(type.getValue().intValue()));
                        continue;
                    }
                    if (data.getTagNo() == 1) {
                        DERInteger state = DERInteger.getInstance(data);
                        transInfoMap.put("state", state.getValue().intValue());
                        continue;
                    }
                    if (data.getTagNo() == 2) {
                        DEROctetString dn = (DEROctetString)DEROctetString.getInstance(data);
                        transInfoMap.put("userName", new String(dn.getOctets(), "cp1251"));
                        continue;
                    }
                    if (data.getTagNo() == 3) {
                        DERGeneralizedTime notBefore = DERGeneralizedTime.getInstance(data.getObject());
                        try {
                            transInfoMap.put("notBefore", notBefore.getDate());
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (data.getTagNo() != 4) continue;
                    DERGeneralizedTime notAfter = DERGeneralizedTime.getInstance(data.getObject());
                    try {
                        transInfoMap.put("notAfter", notAfter.getDate());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                transactionList.add(transInfoMap);
            }
            ArrayList arrayList = transactionList;
            return arrayList;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

