/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp.applet;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kz.gamma.cmp.AdminSecretInfo;
import kz.gamma.cmp.BillingInfo;
import kz.gamma.cmp.BillingRequest;
import kz.gamma.cmp.BillingResponse;
import kz.gamma.cmp.CertificateConfirmationRequest;
import kz.gamma.cmp.CertificateConfirmationResponse;
import kz.gamma.cmp.CertificationRequest;
import kz.gamma.cmp.CertificationResponse;
import kz.gamma.cmp.CmpInfo;
import kz.gamma.cmp.DepositionRequest;
import kz.gamma.cmp.DepositionResponse;
import kz.gamma.cmp.InitialRegistrationRequest;
import kz.gamma.cmp.InitialRegistrationResponse;
import kz.gamma.cmp.KeyUpdateRequest;
import kz.gamma.cmp.KeyUpdateResponse;
import kz.gamma.cmp.OCSPRequest;
import kz.gamma.cmp.OCSPResponse;
import kz.gamma.cmp.PollingRequest;
import kz.gamma.cmp.PollingResponse;
import kz.gamma.cmp.RevocationRequest;
import kz.gamma.cmp.RevocationResponse;
import kz.gamma.cmp.SecretRequest;
import kz.gamma.cmp.SecretResponse;
import kz.gamma.cmp.TransactionInfo;
import kz.gamma.cmp.TransactionListRequest;
import kz.gamma.cmp.TransactionListResponse;
import kz.gamma.cmp.UserSecretInfo;
import kz.gamma.cmp.X509ObjectRequest;
import kz.gamma.cmp.X509ObjectResponse;
import kz.gamma.tumarcsp.CommonApplet;
import kz.gamma.util.encoders.Base64;

public class CmpApplet
extends CommonApplet {
    public static final int USER = 0;
    public static final int ADMINISTRATOR = 1;

    @Override
    public void init() {
        super.init();
        System.out.println("CmpApplet loading...");
        try {
            System.out.println("CmpApplet. Implementation-Title: " + CmpApplet.class.getPackage().getImplementationTitle());
            System.out.println("CmpApplet. Implementation-Version: " + CmpApplet.class.getPackage().getImplementationVersion());
            System.out.println("CmpApplet. Implementation-Vendor: " + CmpApplet.class.getPackage().getImplementationVendor());
        }
        catch (Throwable t) {
            System.out.println("CmpApplet. Implementation-Title: unknown");
            System.out.println("CmpApplet. Implementation-Version: unknown");
            System.out.println("CmpApplet. Implementation-Vendor: unknown");
        }
        System.out.println("CmpApplet loaded");
    }

    @Override
    public void destroy() {
        System.out.println("CmpApplet unloading...");
        System.out.println("CmpApplet unloaded");
        super.destroy();
    }

    public String x509objectRequest(String profile, String serverCert, String x509objectType) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            x509objectType = x509objectType != null && x509objectType.equals("null") ? null : x509objectType;
            X509ObjectRequest x509ObjectRequest = new X509ObjectRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("objectTypeOid", x509objectType);
            params.put("acquireContextFlag", 64);
            byte[] request = x509ObjectRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0421\u041e\u0421 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String x509objectResponse(String profile, String response, String x509objectType) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            x509objectType = x509objectType != null && x509objectType.equals("null") ? null : x509objectType;
            X509ObjectResponse x509ObjectResponse = new X509ObjectResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("objectTypeOid", x509objectType);
            params.put("acquireContextFlag", 64);
            boolean result = x509ObjectResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + x509ObjectResponse.getResponseType() + ".\nError CMP status: " + x509ObjectResponse.getErrorCmpStatus() + ".\nError CMP fail: " + x509ObjectResponse.getErrorCmpFail());
            }
            if (x509ObjectResponse.getUsefulData() == null) {
                throw new Exception("\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438");
            }
            return new String(Base64.encode(x509ObjectResponse.getUsefulData()));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0421\u041e\u0421 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String addSecretRequest(String profile, String serverCert, int type, String uid, String userPassword, boolean userState, String commonName, String organizationalUnit, String organization, String city, String country, String birthDate, String telephoneNumber, String mail) {
        return this.addSecretRequest(profile, serverCert, type, uid, userPassword, userState, commonName, organizationalUnit, organization, city, country, birthDate, telephoneNumber, mail, null, null);
    }

    public String addSecretRequest(String profile, String serverCert, int type, String uid, String userPassword, boolean userState, String commonName, String organizationalUnit, String organization, String city, String country, String birthDate, String telephoneNumber, String mail, String displayName, String trustName) {
        try {
            Object si;
            this.lastError = "";
            this.checkProvider();
            byte[] body = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            uid = uid != null && uid.equals("null") ? null : uid;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            commonName = commonName != null && commonName.equals("null") ? null : commonName;
            organizationalUnit = organizationalUnit != null && organizationalUnit.equals("null") ? null : organizationalUnit;
            organization = organization != null && organization.equals("null") ? null : organization;
            city = city != null && city.equals("null") ? null : city;
            country = country != null && country.equals("null") ? null : country;
            birthDate = birthDate != null && birthDate.equals("null") ? null : birthDate;
            telephoneNumber = telephoneNumber != null && telephoneNumber.equals("null") ? null : telephoneNumber;
            mail = mail != null && mail.equals("null") ? null : mail;
            displayName = displayName != null && displayName.equals("null") ? null : displayName;
            String string = trustName = trustName != null && trustName.equals("null") ? null : trustName;
            if (type != 0 && type != 1) {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            params.put("userState", userState);
            params.put("uid", uid);
            params.put("userPassword", userPassword);
            params.put("commonName", commonName);
            params.put("organizationalUnit", organizationalUnit);
            params.put("organization", organization);
            params.put("city", city);
            params.put("country", country);
            params.put("displayName", displayName);
            params.put("trustName", trustName);
            if (type == 0) {
                si = new UserSecretInfo();
                body = ((UserSecretInfo)si).createAddBody(params);
            } else if (type == 1) {
                if (birthDate != null) {
                    Date date = this.sdfShort.parse(birthDate);
                    params.put("birthDate", date);
                }
                params.put("telephoneNumber", telephoneNumber);
                params.put("mail", mail);
                si = new AdminSecretInfo();
                body = ((AdminSecretInfo)si).createAddBody(params);
            }
            SecretRequest s = new SecretRequest();
            params.clear();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("body", body);
            params.put("operationType", 0);
            if (type == 0) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
            } else if (type == 1) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.14");
            }
            params.put("acquireContextFlag", 64);
            byte[] request = s.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public boolean addSecretResponse(String profile, String response, int type) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            SecretResponse secretResponse = new SecretResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("operationType", 0);
            if (type == 0) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
            } else if (type == 1) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.14");
            } else {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            params.put("acquireContextFlag", 64);
            boolean result = secretResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + secretResponse.getResponseType() + ".\nError CMP status: " + secretResponse.getErrorCmpStatus() + ".\nError CMP fail: " + secretResponse.getErrorCmpFail());
            }
            return result;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return false;
        }
    }

    public String modSecretRequest(String profile, String serverCert, int type, String userName, String uid, String userPassword, boolean userState, String birthDate, String telephoneNumber, String mail) {
        return this.modSecretRequest(profile, serverCert, type, userName, uid, userPassword, userState, birthDate, telephoneNumber, mail, null, null);
    }

    public String modSecretRequest(String profile, String serverCert, int type, String userName, String uid, String userPassword, boolean userState, String birthDate, String telephoneNumber, String mail, String displayName, String trustName) {
        try {
            Object si;
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            userName = userName != null && userName.equals("null") ? null : userName;
            uid = uid != null && uid.equals("null") ? null : uid;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            birthDate = birthDate != null && birthDate.equals("null") ? null : birthDate;
            telephoneNumber = telephoneNumber != null && telephoneNumber.equals("null") ? null : telephoneNumber;
            mail = mail != null && mail.equals("null") ? null : mail;
            displayName = displayName != null && displayName.equals("null") ? null : displayName;
            trustName = trustName != null && trustName.equals("null") ? null : trustName;
            byte[] body = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (type != 0 && type != 1) {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            params.put("uid", uid);
            params.put("userName", userName);
            params.put("userPassword", userPassword);
            params.put("userState", userState);
            params.put("displayName", displayName);
            params.put("trustName", trustName);
            if (type == 0) {
                si = new UserSecretInfo();
                body = ((UserSecretInfo)si).createModBody(params);
            } else if (type == 1) {
                if (birthDate != null) {
                    Date date = this.sdfShort.parse(birthDate);
                    params.put("birthDate", date);
                }
                params.put("telephoneNumber", telephoneNumber);
                params.put("mail", mail);
                si = new AdminSecretInfo();
                body = ((AdminSecretInfo)si).createModBody(params);
            }
            SecretRequest s = new SecretRequest();
            params.clear();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("body", body);
            params.put("operationType", 1);
            if (type == 0) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
            } else if (type == 1) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.15");
            }
            params.put("acquireContextFlag", 64);
            byte[] request = s.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public boolean modSecretResponse(String profile, String response, int type) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            SecretResponse secretResponse = new SecretResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("operationType", 1);
            if (type == 0) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
            } else if (type == 1) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.15");
            } else {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            params.put("acquireContextFlag", 64);
            boolean result = secretResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + secretResponse.getResponseType() + ".\nError CMP status: " + secretResponse.getErrorCmpStatus() + ".\nError CMP fail: " + secretResponse.getErrorCmpFail());
            }
            return result;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return false;
        }
    }

    public String getSecretRequest(String profile, String serverCert, int type, String userName) {
        try {
            Object si;
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            userName = userName != null && userName.equals("null") ? null : userName;
            byte[] body = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("userName", userName);
            if (type == 0) {
                si = new UserSecretInfo();
                body = ((UserSecretInfo)si).createGetBody(params);
            } else if (type == 1) {
                si = new AdminSecretInfo();
                body = ((AdminSecretInfo)si).createGetBody(params);
            } else {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            SecretRequest s = new SecretRequest();
            params.clear();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("body", body);
            params.put("operationType", 2);
            if (type == 0) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
            } else if (type == 1) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.16");
            }
            params.put("acquireContextFlag", 64);
            byte[] request = s.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String getSecretResponse(String profile, String response, int type) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            SecretResponse secretResponse = new SecretResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("operationType", 2);
            if (type == 0) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
            } else if (type == 1) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.16");
            } else {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            params.put("acquireContextFlag", 64);
            boolean result = secretResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + secretResponse.getResponseType() + ".\nError CMP status: " + secretResponse.getErrorCmpStatus() + ".\nError CMP fail: " + secretResponse.getErrorCmpFail());
            }
            if (secretResponse.getUsefulData() == null) {
                throw new Exception("\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438");
            }
            Map resultMap = null;
            if (type == 0) {
                String trustName;
                UserSecretInfo si = new UserSecretInfo();
                resultMap = si.parseBody(secretResponse.getUsefulData());
                Boolean userState = (Boolean)resultMap.get("userState");
                String userStateString = null;
                if (userState == null) {
                    userStateString = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
                } else if (userState.booleanValue()) {
                    userStateString = "\u0412\u0430\u043b\u0438\u0434\u0435\u043d";
                } else if (!userState.booleanValue()) {
                    userStateString = "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                }
                String displayName = (String)resultMap.get("displayName");
                if (displayName == null || displayName.trim().length() == 0) {
                    displayName = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442";
                }
                if ((trustName = (String)resultMap.get("trustName")) == null || trustName.trim().length() == 0) {
                    trustName = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442";
                }
                return resultMap.get("uid") + COLUMN_SEPARATOR + resultMap.get("userName") + COLUMN_SEPARATOR + resultMap.get("userPassword") + COLUMN_SEPARATOR + userStateString + COLUMN_SEPARATOR + displayName + COLUMN_SEPARATOR + trustName;
            }
            if (type == 1) {
                String trustName;
                String displayName;
                AdminSecretInfo si = new AdminSecretInfo();
                resultMap = si.parseBody(secretResponse.getUsefulData());
                Boolean userState = (Boolean)resultMap.get("userState");
                String userStateString = null;
                if (userState == null) {
                    userStateString = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
                } else if (userState.booleanValue()) {
                    userStateString = "\u0412\u0430\u043b\u0438\u0434\u0435\u043d";
                } else if (!userState.booleanValue()) {
                    userStateString = "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                }
                Date birthDate = (Date)resultMap.get("birthDate");
                String birthDateString = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
                if (birthDate != null) {
                    birthDateString = this.sdfShort.format(birthDate);
                }
                if ((displayName = (String)resultMap.get("displayName")) == null || displayName.trim().length() == 0) {
                    displayName = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442";
                }
                if ((trustName = (String)resultMap.get("trustName")) == null || trustName.trim().length() == 0) {
                    trustName = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442";
                }
                return resultMap.get("uid") + COLUMN_SEPARATOR + resultMap.get("userName") + COLUMN_SEPARATOR + resultMap.get("userPassword") + COLUMN_SEPARATOR + userStateString + COLUMN_SEPARATOR + birthDateString + COLUMN_SEPARATOR + resultMap.get("telephoneNumber") + COLUMN_SEPARATOR + resultMap.get("mail") + COLUMN_SEPARATOR + displayName + COLUMN_SEPARATOR + trustName;
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String delSecretRequest(String profile, String serverCert, int type, String userName) {
        return this.delSecretRequest(profile, serverCert, type, userName, null);
    }

    public String delSecretRequest(String profile, String serverCert, int type, String userName, String uid) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            userName = userName != null && userName.equals("null") ? null : userName;
            uid = uid != null && uid.equals("null") ? null : uid;
            byte[] body = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (userName != null) {
                params.put("userName", userName);
            }
            if (uid != null) {
                params.put("uid", uid);
            }
            UserSecretInfo si = new UserSecretInfo();
            body = si.createDelBody(params);
            SecretRequest s = new SecretRequest();
            params.clear();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("body", body);
            params.put("operationType", 3);
            if (type == 0) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
            } else if (type == 1) {
                params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.8");
            }
            params.put("acquireContextFlag", 64);
            byte[] request = s.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public boolean delSecretResponse(String profile, String response, int type) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            SecretResponse secretResponse = new SecretResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("operationType", 3);
            params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.8");
            params.put("acquireContextFlag", 64);
            boolean result = secretResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + secretResponse.getResponseType() + ".\nError CMP status: " + secretResponse.getErrorCmpStatus() + ".\nError CMP fail: " + secretResponse.getErrorCmpFail());
            }
            return result;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0441\u0435\u043a\u0440\u0435\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return false;
        }
    }

    public String transactionListRequest(String profile, String serverCert) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            TransactionListRequest tlr = new TransactionListRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("acquireContextFlag", 64);
            byte[] request = tlr.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String transactionListResponse(String profile, String response) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            TransactionListResponse tlr = new TransactionListResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("acquireContextFlag", 64);
            boolean result = tlr.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + tlr.getResponseType() + ".\nError CMP status: " + tlr.getErrorCmpStatus() + ".\nError CMP fail: " + tlr.getErrorCmpFail());
            }
            if (tlr.getUsefulData() == null) {
                throw new Exception("\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438");
            }
            StringBuilder stringBuilder = new StringBuilder();
            TransactionInfo transactionInfo = new TransactionInfo();
            List parsedBody = transactionInfo.parseBody(tlr.getUsefulData());
            for (Object transaction : parsedBody) {
                Map info = (Map)transaction;
                stringBuilder.append(info.get("transactionId")).append(COLUMN_SEPARATOR).append(info.get("type")).append(COLUMN_SEPARATOR).append(info.get("state")).append(COLUMN_SEPARATOR).append(info.get("userName")).append(COLUMN_SEPARATOR).append(this.sdfShort.format(info.get("notBefore"))).append(COLUMN_SEPARATOR).append(this.sdfShort.format(info.get("notAfter"))).append(ROW_SEPARATOR);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - ROW_SEPARATOR.length(), stringBuilder.length());
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String pollingRequest(String profile, String serverCert, String transactionId, String uid, String userPassword) {
        return this.pollingRequest(profile, serverCert, transactionId, uid, userPassword, null);
    }

    public String pollingRequest(String profile, String serverCert, String transactionId, String uid, String userPassword, String genOid) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            transactionId = transactionId != null && transactionId.equals("null") ? null : transactionId;
            uid = uid != null && uid.equals("null") ? null : uid;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            genOid = genOid != null && genOid.equals("null") ? null : genOid;
            PollingRequest pollingRequest = new PollingRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("transactionId", transactionId);
            params.put("uid", uid);
            params.put("userPassword", userPassword);
            params.put("acquireContextFlag", 64);
            params.put("genOid", genOid);
            byte[] request = pollingRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u043f\u0440\u043e\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public Integer pollingResponse(String profile, String response, boolean processResponse, String userPassword) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            PollingResponse pollingResponse = new PollingResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("processResponse", processResponse);
            params.put("userPassword", userPassword);
            params.put("acquireContextFlag", 64);
            boolean result = pollingResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u043f\u0440\u043e\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + pollingResponse.getResponseType() + ".\nError CMP status: " + pollingResponse.getErrorCmpStatus() + ".\nError CMP fail: " + pollingResponse.getErrorCmpFail());
            }
            if (pollingResponse.getResponseTypeCode() == 26) {
                return pollingResponse.getResponseTypeCode();
            }
            return pollingResponse.getStatus();
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u043f\u0440\u043e\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String parsePollingResponse(String response, int type) {
        try {
            this.lastError = "";
            this.checkProvider();
            response = response != null && response.equals("null") ? null : response;
            PollingResponse pollingResponse = new PollingResponse();
            if (response != null) {
                pollingResponse.setResponse(Base64.decode(response));
            }
            switch (type) {
                case 26: {
                    List<byte[]> userCertificates = pollingResponse.getCertificates();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (byte[] cert : userCertificates) {
                        stringBuilder.append(new String(Base64.encode(cert))).append(COLUMN_SEPARATOR);
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.delete(stringBuilder.length() - COLUMN_SEPARATOR.length(), stringBuilder.length());
                    }
                    return stringBuilder.toString();
                }
            }
            throw new IllegalArgumentException("type: " + type);
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u043f\u0440\u043e\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (" + e.getMessage() + "). \u0422\u0438\u043f: " + type;
            e.printStackTrace();
            return null;
        }
    }

    public String certificateConfirmationRequest(String profile, String serverCert, String pollingResponse, boolean confirm) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            pollingResponse = pollingResponse != null && pollingResponse.equals("null") ? null : pollingResponse;
            CertificateConfirmationRequest ccr = new CertificateConfirmationRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            if (pollingResponse != null) {
                params.put("pollingResponse", Base64.decode(pollingResponse));
            }
            params.put("confirm", confirm);
            params.put("acquireContextFlag", 64);
            byte[] request = ccr.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f/\u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f/\u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public boolean certificateConfirmationResponse(String profile, String response) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            CertificateConfirmationResponse ccr = new CertificateConfirmationResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("acquireContextFlag", 64);
            boolean result = ccr.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f/\u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + ccr.getResponseType() + ".\nError CMP status: " + ccr.getErrorCmpStatus() + ".\nError CMP fail: " + ccr.getErrorCmpFail());
            }
            return true;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f/\u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (" + e.getMessage() + ")";
            e.printStackTrace();
            return false;
        }
    }

    public String billingRequest(String profile, String serverCert, String date) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            date = date != null && date.equals("null") ? null : date;
            BillingRequest billingRequest = new BillingRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            Date dateParam = null;
            dateParam = date != null ? this.sdfFull.parse(date) : new Date();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("date", dateParam);
            params.put("acquireContextFlag", 64);
            byte[] request = billingRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String billingResponse(String profile, String response) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            BillingResponse billingResponse = new BillingResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("acquireContextFlag", 64);
            boolean result = billingResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + billingResponse.getResponseType() + ".\nError CMP status: " + billingResponse.getErrorCmpStatus() + ".\nError CMP fail: " + billingResponse.getErrorCmpFail());
            }
            if (billingResponse.getUsefulData() == null) {
                throw new Exception("\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438");
            }
            result = billingResponse.verifyResponse(params);
            BillingInfo billingInfo = new BillingInfo();
            List parsedBody = billingInfo.parseBody(billingResponse.getUsefulData());
            StringBuilder stringBuilder = new StringBuilder();
            for (Object billing : parsedBody) {
                Map info = (Map)billing;
                Integer operType = (Integer)info.get("operType");
                stringBuilder.append(CmpInfo.operTypeToString(operType)).append(COLUMN_SEPARATOR).append(this.sdfShort.format(info.get("operTime"))).append(COLUMN_SEPARATOR).append(info.get("service")).append(COLUMN_SEPARATOR).append(info.get("serialNumber")).append(COLUMN_SEPARATOR).append(info.get("subject")).append(COLUMN_SEPARATOR).append(this.sdfShort.format(info.get("notBefore"))).append(COLUMN_SEPARATOR).append(this.sdfShort.format(info.get("notAfter"))).append(COLUMN_SEPARATOR).append(info.get("keyUsage")).append(COLUMN_SEPARATOR).append(info.get("keyOID")).append(COLUMN_SEPARATOR).append(info.get("policyList"));
                if (operType.equals(1)) {
                    stringBuilder.append(COLUMN_SEPARATOR).append(info.get("reason")).append(ROW_SEPARATOR);
                    continue;
                }
                stringBuilder.append(ROW_SEPARATOR);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - ROW_SEPARATOR.length(), stringBuilder.length());
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String certificationRequest(String profile, String serverCert) {
        return this.certificationRequest(profile, serverCert, null);
    }

    public String certificationRequest(String profile, String serverCert, String keyOids) {
        return this.certificationRequest(profile, serverCert, keyOids, null);
    }

    public String certificationRequest(String profile, String serverCert, String keyOids, String subjectAltName) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            keyOids = keyOids != null && keyOids.equals("null") ? null : keyOids;
            subjectAltName = subjectAltName != null && subjectAltName.equals("null") ? null : subjectAltName;
            CertificationRequest certificationRequest = new CertificationRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (keyOids != null && keyOids.trim().length() > 0) {
                String[] keyOidsArray = keyOids.split(IN_COLUMN_SEPARATOR);
                List<String> keyOidsList = Arrays.asList(keyOidsArray);
                params.put("keyOidsList", keyOidsList);
            }
            if (subjectAltName != null && subjectAltName.trim().length() > 0) {
                String[] subjectAltNameArray = subjectAltName.split(IN_COLUMN_SEPARATOR);
                List<String> subjectAltNameList = Arrays.asList(subjectAltNameArray);
                params.put("subjectAltNameList", subjectAltNameList);
            }
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("acquireContextFlag", 64);
            byte[] request = certificationRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (CR) \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (CR) (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String certificationResponse(String profile, String response) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            CertificationResponse certificationResponse = new CertificationResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("acquireContextFlag", 64);
            boolean result = certificationResponse.verifyResponse(params);
            if (!result) {
                if (certificationResponse.getResponseTypeCode() == 23) {
                    throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (CR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + certificationResponse.getResponseType() + ".\nError CMP status: " + certificationResponse.getErrorCmpStatus() + ".\nError CMP fail: " + certificationResponse.getErrorCmpFail());
                }
                if (certificationResponse.getResponseTypeCode() == 3) {
                    String cpStatus = CmpInfo.codeToFail(certificationResponse.getStatus());
                    throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (CR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nPKI_CMP_CP status: " + cpStatus);
                }
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (CR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nUnkown response type code: " + certificationResponse.getResponseTypeCode());
            }
            if (certificationResponse.getResponseTypeCode() == 3) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.valueOf(certificationResponse.getStatus())).append(COLUMN_SEPARATOR).append(certificationResponse.getTransactionId());
                return stringBuilder.toString();
            }
            throw new Exception("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (CR): " + certificationResponse.getResponseTypeCode());
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (CR) (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String keyUpdateRequest(String profile, String serverCert, String notAfter, String userExchCertificate, String userSignCertificate) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            notAfter = notAfter != null && notAfter.equals("null") ? null : notAfter;
            userExchCertificate = userExchCertificate != null && userExchCertificate.equals("null") ? null : userExchCertificate;
            userSignCertificate = userSignCertificate != null && userSignCertificate.equals("null") ? null : userSignCertificate;
            KeyUpdateRequest keyUpdateRequest = new KeyUpdateRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            if (notAfter != null) {
                Date date = this.sdfShort.parse(notAfter);
                params.put("notAfter", date);
            }
            if (userExchCertificate != null) {
                params.put("userExchCertificate", Base64.decode(userExchCertificate));
            }
            if (userSignCertificate != null) {
                params.put("userSignCertificate", Base64.decode(userSignCertificate));
            }
            params.put("acquireContextFlag", 64);
            byte[] request = keyUpdateRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (KUR) \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441  \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (KUR) (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String keyUpdateRequest(String profile, String serverCert, String notAfter, String userCertificates) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            notAfter = notAfter != null && notAfter.equals("null") ? null : notAfter;
            userCertificates = userCertificates != null && userCertificates.equals("null") ? null : userCertificates;
            KeyUpdateRequest keyUpdateRequest = new KeyUpdateRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (userCertificates != null && userCertificates.trim().length() > 0) {
                String[] userCertificatesArray = userCertificates.split(IN_COLUMN_SEPARATOR);
                LinkedList<byte[]> userCertificatesList = new LinkedList<byte[]>();
                for (String userCertificate : userCertificatesArray) {
                    userCertificatesList.add(Base64.decode(userCertificate));
                }
                params.put("userCertificates", userCertificatesList);
            }
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            if (notAfter != null) {
                Date date = this.sdfShort.parse(notAfter);
                params.put("notAfter", date);
            }
            params.put("acquireContextFlag", 64);
            byte[] request = keyUpdateRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (KUR) \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441  \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (KUR) (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String keyUpdateResponse(String profile, String response) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            KeyUpdateResponse keyUpdateResponse = new KeyUpdateResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("acquireContextFlag", 64);
            boolean result = keyUpdateResponse.verifyResponse(params);
            if (!result) {
                if (keyUpdateResponse.getResponseTypeCode() == 23) {
                    throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (KUR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + keyUpdateResponse.getResponseType() + ".\nError CMP status: " + keyUpdateResponse.getErrorCmpStatus() + ".\nError CMP fail: " + keyUpdateResponse.getErrorCmpFail());
                }
                if (keyUpdateResponse.getResponseTypeCode() == 8) {
                    String kupStatus = CmpInfo.codeToFail(keyUpdateResponse.getStatus());
                    throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (KUR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nPKI_CMP_KUP status: " + kupStatus);
                }
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (KUR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nUnkown response type code: " + keyUpdateResponse.getResponseTypeCode());
            }
            if (keyUpdateResponse.getResponseTypeCode() == 8) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.valueOf(keyUpdateResponse.getStatus())).append(COLUMN_SEPARATOR).append(keyUpdateResponse.getTransactionId());
                return stringBuilder.toString();
            }
            throw new Exception("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (KUR): " + keyUpdateResponse.getResponseTypeCode());
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (KUR) (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String depositionRequest(String profile, String serverCert, String uid, String userPassword, String transactionId) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            uid = uid != null && uid.equals("null") ? null : uid;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            transactionId = transactionId != null && transactionId.equals("null") ? null : transactionId;
            DepositionRequest depositionRequest = new DepositionRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("uid", uid);
            params.put("userPassword", userPassword);
            if (transactionId == null) {
                params.put("acquireContextFlag", 64);
            } else {
                params.put("transactionId", transactionId);
                params.put("acquireContextFlag", -268435456);
            }
            byte[] request = depositionRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435/\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043a\u043b\u044e\u0447\u0435\u0439 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(new String(Base64.encode(request)));
            if (transactionId == null) {
                stringBuilder.append(COLUMN_SEPARATOR).append(depositionRequest.getOtp());
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f/\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043a\u043b\u044e\u0447\u0435\u0439 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String depositionResponse(String profile, String response, String userPassword, String otp) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            otp = otp != null && otp.equals("null") ? null : otp;
            DepositionResponse depositionResponse = new DepositionResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("userPassword", userPassword);
            if (otp == null) {
                params.put("acquireContextFlag", 64);
            } else {
                params.put("otp", otp);
                params.put("acquireContextFlag", 72);
            }
            boolean result = depositionResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f/\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043a\u043b\u044e\u0447\u0435\u0439 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + depositionResponse.getResponseType() + ".\nError CMP status: " + depositionResponse.getErrorCmpStatus() + ".\nError CMP fail: " + depositionResponse.getErrorCmpFail());
            }
            if (otp == null) {
                return depositionResponse.getTransactionId();
            }
            return "";
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f/\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043a\u043b\u044e\u0447\u0435\u0439 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String initialRegistrationRequest(String profile, String serverCert, String uid, String userPassword) {
        return this.initialRegistrationRequest(profile, null, serverCert, uid, userPassword);
    }

    public String initialRegistrationRequest(String profile, String keyOids, String serverCert, String uid, String userPassword) {
        return this.initialRegistrationRequest(profile, keyOids, serverCert, uid, userPassword, null);
    }

    public String initialRegistrationRequest(String profile, String keyOids, String serverCert, String uid, String userPassword, String subjectAltName) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            keyOids = keyOids != null && keyOids.equals("null") ? null : keyOids;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            uid = uid != null && uid.equals("null") ? null : uid;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            subjectAltName = subjectAltName != null && subjectAltName.equals("null") ? null : subjectAltName;
            InitialRegistrationRequest initialRegistrationRequest = new InitialRegistrationRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (keyOids != null && keyOids.trim().length() > 0) {
                String[] keyOidsArray = keyOids.split(IN_COLUMN_SEPARATOR);
                List<String> keyOidsList = Arrays.asList(keyOidsArray);
                params.put("keyOidsList", keyOidsList);
            }
            if (subjectAltName != null && subjectAltName.trim().length() > 0) {
                String[] subjectAltNameArray = subjectAltName.split(IN_COLUMN_SEPARATOR);
                List<String> subjectAltNameList = Arrays.asList(subjectAltNameArray);
                params.put("subjectAltNameList", subjectAltNameList);
            }
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("uid", uid);
            params.put("userPassword", userPassword);
            params.put("acquireContextFlag", 72);
            byte[] request = initialRegistrationRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR) \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR) (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String initialRegistrationResponse(String profile, String response, String userPassword) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            InitialRegistrationResponse initialRegistrationResponse = new InitialRegistrationResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("userPassword", userPassword);
            params.put("acquireContextFlag", 64);
            boolean result = initialRegistrationResponse.verifyResponse(params);
            if (!result) {
                if (initialRegistrationResponse.getResponseTypeCode() == 23) {
                    throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + initialRegistrationResponse.getResponseType() + ".\nError CMP status: " + initialRegistrationResponse.getErrorCmpStatus() + ".\nError CMP fail: " + initialRegistrationResponse.getErrorCmpFail());
                }
                if (initialRegistrationResponse.getResponseTypeCode() == 1) {
                    String ipStatus = CmpInfo.codeToFail(initialRegistrationResponse.getStatus());
                    throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nPKI_CMP_IP status: " + ipStatus);
                }
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR) \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nUnkown response type code: " + initialRegistrationResponse.getResponseTypeCode());
            }
            if (initialRegistrationResponse.getResponseTypeCode() == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.valueOf(initialRegistrationResponse.getStatus())).append(COLUMN_SEPARATOR).append(initialRegistrationResponse.getTransactionId());
                return stringBuilder.toString();
            }
            throw new Exception("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR): " + initialRegistrationResponse.getResponseTypeCode());
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR) (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String parseInitialRegistrationResponse(String response, int type) {
        try {
            this.lastError = "";
            this.checkProvider();
            response = response != null && response.equals("null") ? null : response;
            InitialRegistrationResponse initialRegistrationResponse = new InitialRegistrationResponse();
            if (response != null) {
                initialRegistrationResponse.setResponse(Base64.decode(response));
            }
            switch (type) {
                case 26: {
                    List<byte[]> userCertificates = initialRegistrationResponse.getCertificates();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (byte[] cert : userCertificates) {
                        stringBuilder.append(new String(Base64.encode(cert))).append(COLUMN_SEPARATOR);
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.delete(stringBuilder.length() - COLUMN_SEPARATOR.length(), stringBuilder.length());
                    }
                    return stringBuilder.toString();
                }
            }
            throw new IllegalArgumentException("type: " + type);
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0432\u044b\u043f\u0443\u0441\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (IR) (" + e.getMessage() + "). \u0422\u0438\u043f: " + type;
            e.printStackTrace();
            return null;
        }
    }

    public String ocspRequest(String profile, int keySpec) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            OCSPRequest ocspRequest = new OCSPRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            params.put("keySpec", keySpec);
            byte[] request = ocspRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + "). \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0432 \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u043c \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0435";
            e.printStackTrace();
            return null;
        }
    }

    public Integer ocspResponse(String profile, String response) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            OCSPResponse ocspResponse = new OCSPResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            boolean result = ocspResponse.verifyResponse(params);
            return ocspResponse.getStatus();
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String revocationRequest(String profile, String serverCert, int reason) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            RevocationRequest revocationRequest = new RevocationRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            params.put("reason", reason);
            params.put("acquireContextFlag", 64);
            byte[] request = revocationRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043e\u0442\u0437\u044b\u0432\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u0442\u0437\u044b\u0432\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String revocationRequest(String profile, String serverCert, int reason, String userCertificate, String uid, String userPassword) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            serverCert = serverCert != null && serverCert.equals("null") ? null : serverCert;
            userCertificate = userCertificate != null && userCertificate.equals("null") ? null : userCertificate;
            uid = uid != null && uid.equals("null") ? null : uid;
            userPassword = userPassword != null && userPassword.equals("null") ? null : userPassword;
            RevocationRequest revocationRequest = new RevocationRequest();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (serverCert != null) {
                params.put("serverCertificate", Base64.decode(serverCert));
            }
            if (userCertificate != null) {
                params.put("userCertificate", Base64.decode(userCertificate));
                params.put("acquireContextFlag", -268435456);
            } else {
                params.put("acquireContextFlag", 64);
            }
            params.put("reason", reason);
            params.put("uid", uid);
            params.put("userPassword", userPassword);
            byte[] request = revocationRequest.createRequest(params);
            if (request == null) {
                throw new Exception("\u0417\u0430\u043f\u0440\u043e\u0441 \u043e\u0442\u0437\u044b\u0432\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d");
            }
            return new String(Base64.encode(request));
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u0442\u0437\u044b\u0432\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public boolean revocationResponse(String profile, String response) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals("null") ? null : profile;
            response = response != null && response.equals("null") ? null : response;
            RevocationResponse revocationResponse = new RevocationResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("profile", profile);
            if (response != null) {
                params.put("response", Base64.decode(response));
            }
            params.put("acquireContextFlag", 64);
            boolean result = revocationResponse.verifyResponse(params);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u0442\u0437\u044b\u0432\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u043e.\nCMP response type: " + revocationResponse.getResponseType() + ".\nError CMP status: " + revocationResponse.getErrorCmpStatus() + ".\nError CMP fail: " + revocationResponse.getErrorCmpFail());
            }
            return true;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u0442\u0437\u044b\u0432\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return false;
        }
    }
}

