/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp.utility;

import java.io.UnsupportedEncodingException;
import java.security.Security;
import java.util.HashMap;
import kz.gamma.cmp.SecretRequest;
import kz.gamma.cmp.SecretResponse;
import kz.gamma.cmp.UserSecretInfo;
import kz.gamma.cmp.X509ObjectRequest;
import kz.gamma.cmp.X509ObjectResponse;
import kz.gamma.core.network.RequestSender;
import kz.gamma.jce.provider.GammaTechProvider;

public class CmpSecretUtility {
    public static void main(String[] args) {
        GammaTechProvider gammaTechProvider = new GammaTechProvider();
        Security.addProvider(gammaTechProvider);
        String serviceUrl = args[0];
        String adminProfile = args[1];
        byte[] serverCert = null;
        X509ObjectRequest x509ObjectRequest = new X509ObjectRequest();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("profile", adminProfile);
        params.put("objectTypeOid", "1.3.6.1.5.5.7.4.1");
        params.put("acquireContextFlag", 64);
        byte[] request = x509ObjectRequest.createRequest(params);
        if (request == null) {
            System.err.println("Failed to create a request for a certificate server");
            return;
        }
        byte[] response = RequestSender.sendRequest(serviceUrl, request);
        if (response == null) {
            System.err.println("Unable to get a response from the server");
            return;
        }
        X509ObjectResponse x509ObjectResponse = new X509ObjectResponse();
        params.clear();
        params.put("profile", adminProfile);
        params.put("response", response);
        params.put("objectTypeOid", "1.3.6.1.5.5.7.4.1");
        params.put("acquireContextFlag", 64);
        boolean result = x509ObjectResponse.verifyResponse(params);
        if (!result) {
            System.err.println("Checking the response to the request a certificate server fails.\nCMP response type: " + x509ObjectResponse.getResponseType() + ".\nError CMP status: " + x509ObjectResponse.getErrorCmpStatus() + ".\nError CMP fail: " + x509ObjectResponse.getErrorCmpFail());
            return;
        }
        if (x509ObjectResponse.getUsefulData() == null) {
            System.err.println("Response to request a certificate server does not contain the necessary information");
        } else {
            serverCert = x509ObjectResponse.getUsefulData();
        }
        byte[] body = null;
        SecretRequest secretRequest = new SecretRequest();
        SecretResponse secretResponse = new SecretResponse();
        params.clear();
        params.put("uid", "000000000");
        UserSecretInfo usi = new UserSecretInfo();
        try {
            body = usi.createDelBody(params);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Failed to form a body for the request");
            return;
        }
        secretRequest = new SecretRequest();
        params.clear();
        params.put("profile", adminProfile);
        params.put("serverCertificate", serverCert);
        params.put("body", body);
        params.put("operationType", 3);
        params.put("secretOperationOid", "1.3.6.1.5.5.7.4.12");
        params.put("acquireContextFlag", 64);
        request = secretRequest.createRequest(params);
        if (request == null) {
            System.err.println("Unable to create a request to remove secretions");
            return;
        }
        response = RequestSender.sendRequest(serviceUrl, request);
        if (response == null) {
            System.err.println("Unable to get a response from the server\u0430");
            return;
        }
        secretResponse = new SecretResponse();
        params.clear();
        params.put("profile", adminProfile);
        params.put("response", response);
        params.put("operationType", 3);
        params.put("secretOperationOid", "1.3.6.1.5.5.7.4.50.8");
        params.put("acquireContextFlag", 64);
        result = secretResponse.verifyResponse(params);
        if (!result) {
            System.err.println("Checking response to a request removal of secretions failed.\nCMP response type: " + secretResponse.getResponseType() + ".\nError CMP status: " + secretResponse.getErrorCmpStatus() + ".\nError CMP fail: " + secretResponse.getErrorCmpFail());
            return;
        }
        System.out.println("Removal of secretions produced successfully");
    }
}

