/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1OctetStringParser;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1SequenceParser;
import kz.gamma.asn1.ASN1SetParser;
import kz.gamma.asn1.ASN1StreamParser;
import kz.gamma.asn1.BERConstructedOctetString;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cms.Attribute;
import kz.gamma.asn1.cms.ContentInfoParser;
import kz.gamma.asn1.cms.EncryptedContentInfo;
import kz.gamma.asn1.cms.EncryptedContentInfoParser;
import kz.gamma.asn1.cms.EnvelopedData;
import kz.gamma.asn1.cms.EnvelopedDataParser;
import kz.gamma.asn1.cms.OriginatorInfo;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.cms.CMSException;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.chiper.GammaGOST28147;
import kz.gamma.jce.provider.JCEECPrivateKey;

public class CMSGammaEnvelopedData {
    private List recipientInfs = new ArrayList();
    private ASN1EncodableVector unAttr = new ASN1EncodableVector();
    private int version;
    private X509Name dnSenderIssuer;
    private byte[] snSender;
    private byte[] content;
    X509Certificate senderCert = null;
    GammaGOST28147 enc = new GammaGOST28147();

    public EnvelopedData generateEnvelopedData(X509Certificate cert) throws CertificateEncodingException, IOException {
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        recipientInfos.add(new DERInteger(3));
        ASN1EncodableVector vecSendInf = new ASN1EncodableVector();
        vecSendInf.add(new X509Name(cert.getIssuerDN().toString()));
        vecSendInf.add(new DERInteger(cert.getSerialNumber()));
        recipientInfos.add(new DERTaggedObject(0, new DERSequence(vecSendInf)));
        recipientInfos.add(new AlgorithmIdentifier(GammaObjectIndentifiers.gost28147.getDERObjectIdentifier(), new DERNull()));
        for (RecipientInfGamma recipient : this.recipientInfs) {
            recipientInfos.add(recipient.toASN1Object());
        }
        ASN1InputStream inStr = new ASN1InputStream(cert.getEncoded());
        OriginatorInfo originatorInfo = new OriginatorInfo(new DERSet(inStr.readObject()), null);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new DERObjectIdentifier("1.2.840.113549.1.7.2"), new AlgorithmIdentifier(GammaObjectIndentifiers.gost28147.getDERObjectIdentifier(), new DERNull()), new BERConstructedOctetString(this.content));
        this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.8"), new DERSet(new X509Name(cert.getSubjectDN().getName()))));
        return new EnvelopedData(originatorInfo, new DERSet(new DERSequence(recipientInfos)), encryptedContentInfo, new DERSet(this.unAttr));
    }

    public void addKeyRecipient(X509Certificate recipientCert) {
        RecipientInfGamma rec = new RecipientInfGamma(recipientCert, this.enc);
        this.recipientInfs.add(rec);
        this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.9"), new DERSet(new X509Name(recipientCert.getSubjectDN().getName()))));
    }

    public void addUnprotectedAttrs(Attribute attr) {
        this.unAttr.add(attr);
    }

    public CMSGammaEnvelopedData() {
    }

    public CMSGammaEnvelopedData(byte[] cmsDevelopedBuf) throws IOException, NoSuchProviderException, CertificateException, CMSException, NoSuchAlgorithmException {
        ASN1StreamParser as = new ASN1StreamParser(cmsDevelopedBuf);
        ContentInfoParser cP = new ContentInfoParser((ASN1SequenceParser)as.readObject());
        EnvelopedDataParser eP = new EnvelopedDataParser((ASN1SequenceParser)cP.getContent(16));
        this.version = eP.getVersion().getValue().intValue();
        ASN1SetParser certPars = eP.getCertificates();
        DERTaggedObject certObject = (DERTaggedObject)certPars.readObject();
        DEREncodable en = certObject.getObjectParser(0, true);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.senderCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(en.getDERObject().getEncoded()));
        DERObject obj = eP.getRecipientInfos().getDERObject();
        DERSequence obj1 = (DERSequence)((DERSet)obj).getObjectAt(0);
        int ver = ((DERInteger)obj1.getObjectAt(0)).getValue().intValue();
        this.dnSenderIssuer = new X509Name((ASN1Sequence)((DERSequence)((DERTaggedObject)obj1.getObjectAt(1)).getObjectParser(0, true)).getObjectAt(0));
        this.snSender = ((DERInteger)((DERSequence)((DERTaggedObject)obj1.getObjectAt(1)).getObjectParser(0, true)).getObjectAt(1)).getEncoded();
        this.recipientInfs.clear();
        int j = obj1.size() - 3;
        for (int i = 0; i < j; ++i) {
            DERSequence seq = (DERSequence)((DERSequence)obj1.getObjectAt(i + 3)).getObjectAt(0);
            this.recipientInfs.add(new RecipientInfGamma(seq));
        }
        EncryptedContentInfoParser ecP = eP.getEncryptedContentInfo();
        this.content = ((DEROctetString)((ASN1OctetStringParser)ecP.getEncryptedContent(4)).getDERObject()).getOctets();
        ASN1SetParser prs = eP.getUnprotectedAttrs();
        DEREncodable nextObject = prs.readObject();
        while (nextObject != null) {
            this.unAttr.add(nextObject);
            nextObject = prs.readObject();
        }
    }

    public void cryptText(byte[] buf, JCEECPrivateKey privKey) {
        this.enc.setHProv(privKey.getHandleProv());
        this.enc.genSesKey(26655);
        this.content = this.enc.doEncrypt(buf);
    }

    protected void finalize() throws Throwable {
        try {
            this.enc.destroySessionKey();
        }
        finally {
            super.finalize();
        }
    }

    @Deprecated
    public byte[] dencryptText(KeyStore store, String password) {
        return this.decryptText(store, password);
    }

    public byte[] decryptText(KeyStore store, String password) {
        password = password == null ? "" : password.trim();
        JCEECPrivateKey prKey = null;
        RecipientInfGamma rinf2 = null;
        for (RecipientInfGamma rinf2 : this.recipientInfs) {
            try {
                prKey = (JCEECPrivateKey)store.getKey(UtilCM.array2hex(rinf2.snRecipient.getValue().toByteArray()), password.toCharArray());
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (UnrecoverableKeyException e) {
                e.printStackTrace();
            }
            if (prKey == null) continue;
        }
        if (prKey == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        }
        GammaGOST28147 decr = new GammaGOST28147();
        decr.setHProv(prKey.getHandleProv());
        decr.setSessionKey(rinf2.keySecret, this.senderCert.getPublicKey().getEncoded());
        byte[] tmp = decr.doDecrypt(this.content);
        return tmp;
    }

    public X509Certificate getSenderCert() {
        return this.senderCert;
    }

    public ASN1EncodableVector getUnAttr() {
        return this.unAttr;
    }

    protected class RecipientInfGamma
    extends ASN1Encodable {
        X509Name dnIssuerRecipient = null;
        DERInteger snRecipient = null;
        byte[] keySecret = null;

        public RecipientInfGamma(DERSequence der) {
            this.dnIssuerRecipient = new X509Name((ASN1Sequence)((DERSequence)der.getObjectAt(0)).getObjectAt(0));
            this.snRecipient = (DERInteger)((DERSequence)der.getObjectAt(0)).getObjectAt(1);
            this.keySecret = ((DEROctetString)der.getObjectAt(1)).getOctets();
        }

        public RecipientInfGamma(X509Certificate certRecipient, GammaGOST28147 enc) {
            this.keySecret = enc.getSessionKey(certRecipient.getPublicKey());
            this.dnIssuerRecipient = new X509Name(certRecipient.getIssuerDN().getName());
            this.snRecipient = new DERInteger(certRecipient.getSerialNumber());
        }

        @Override
        public DERObject toASN1Object() {
            ASN1EncodableVector recInf = new ASN1EncodableVector();
            ASN1EncodableVector infKeyId = new ASN1EncodableVector();
            infKeyId.add(this.dnIssuerRecipient);
            infKeyId.add(this.snRecipient);
            recInf.add(new DERSequence(infKeyId));
            BERConstructedOctetString oct = new BERConstructedOctetString(this.keySecret);
            recInf.add(oct);
            ASN1EncodableVector out = new ASN1EncodableVector();
            out.add(new DERSequence(recInf));
            return new DERSequence(out);
        }
    }
}

