/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStoreException;
import java.util.Arrays;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSProcessable;
import kz.gamma.cms.CMSSignedData;
import kz.gamma.cms.CMSSignedDataGenerator;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.x509.NoSuchStoreException;

public class CMSSignedDataMultipleSignatureGenerator
extends CMSSignedDataGenerator {
    private CMSSignedData originalCMS;

    public CMSSignedDataMultipleSignatureGenerator(CMSSignedData originalCMSSignedData) {
        this.originalCMS = originalCMSSignedData;
    }

    @Override
    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, String sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        try {
            if (this.originalCMS.getSignedContent() != null && content != null && !Arrays.equals((byte[])this.originalCMS.getSignedContent().getContent(), (byte[])content.getContent())) {
                throw new CMSException("content must be the same as content in the original cms");
            }
            if (content == null) {
                if (this.originalCMS.getSignedContent() == null) {
                    throw new CMSException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438 - content.");
                }
                content = this.originalCMS.getSignedContent();
            }
            this.addSigners(this.originalCMS.getSignerInfos());
            this.addCertificatesAndCRLs(this.originalCMS.getCertificatesAndCRLs("Collection", GammaTechProvider.PROVIDER_NAME));
            this.addAttributeCertificates(this.originalCMS.getAttributeCertificates("Collection", GammaTechProvider.PROVIDER_NAME));
            return super.generate(signedContentType, content, encapsulate, sigProvider, addDefaultAttributes);
        }
        catch (CertStoreException | NoSuchStoreException e) {
            e.printStackTrace();
            throw new CMSException(e.getMessage());
        }
    }

    @Override
    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(signedContentType, content, encapsulate, sigProvider, true);
    }

    @Override
    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    @Override
    public CMSSignedData generate(CMSProcessable content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, true, sigProvider);
    }

    public CMSSignedData generate(String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, this.originalCMS.getSignedContent(), true, sigProvider);
    }
}

