/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.gamma.asn1.ASN1Object;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cms.AttributeTable;
import kz.gamma.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.asn1.oiw.OIWObjectIdentifiers;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.AttributeCertificate;
import kz.gamma.asn1.x9.X9ObjectIdentifiers;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSUtils;
import kz.gamma.cms.SignerInformationStore;
import kz.gamma.x509.X509AttributeCertificate;
import kz.gamma.x509.X509Store;

public class CMSSignedGenerator {
    public static final String DATA = PKCSObjectIdentifiers.data.getId();
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_GOST3411G = GammaObjectIndentifiers.gost34311.getId();
    public static final String DIGEST_GOST3411_2012_512 = GammaObjectIndentifiers.gostR3411_2012_512.getId();
    public static final String DIGEST_GOST3411_2012_256 = GammaObjectIndentifiers.gostR3411_2012_256.getId();
    public static final String DIGEST_KZ_GOST_34_11_95 = KZObjectIndentifiers.GOST_34_11_95.getId();
    public static final String DIGEST_KZ_GOST_34_11_95_TEST = KZObjectIndentifiers.GOST_34_11_95_TEST.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_RECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    public static final String ENCRYPTION_ECGOST3410 = GammaObjectIndentifiers.gost34310.getId();
    public static final String ENCRYPTION_GOST3410_2012 = GammaObjectIndentifiers.gost3410_2012_512.getId();
    public static final String ENCRYPTION_GOST3410_2012_2 = GammaObjectIndentifiers.gost3410_2012_256.getId();
    public static final String ENCRYPTION_KZ_GOST_34_310_SIGNATURE = KZObjectIndentifiers.GOST_34_310_SIGNATURE.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA1 = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA224 = X9ObjectIdentifiers.ecdsa_with_SHA224.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA256 = X9ObjectIdentifiers.ecdsa_with_SHA256.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA384 = X9ObjectIdentifiers.ecdsa_with_SHA384.getId();
    private static final String ENCRYPTION_ECDSA_WITH_SHA512 = X9ObjectIdentifiers.ecdsa_with_SHA512.getId();
    private static final Set NO_PARAMS = new HashSet();
    private static final Map EC_ALGORITHMS = new HashMap();
    protected List _certs = new ArrayList();
    protected List _crls = new ArrayList();
    protected List _signers = new ArrayList();
    protected Map _digests = new HashMap();

    protected CMSSignedGenerator() {
    }

    protected String getEncOID(PrivateKey key, String digestOID) {
        String encOID;
        if (key instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(key.getAlgorithm())) {
            encOID = ENCRYPTION_RSA;
        } else if (key instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(key.getAlgorithm())) {
            encOID = ENCRYPTION_DSA;
            if (!digestOID.equals(DIGEST_SHA1)) {
                throw new IllegalArgumentException("can't mix DSA with anything but SHA1");
            }
        } else {
            encOID = digestOID.equals(DIGEST_GOST3411G) ? ENCRYPTION_ECGOST3410 : (digestOID.equals(DIGEST_KZ_GOST_34_11_95) || digestOID.equals(DIGEST_KZ_GOST_34_11_95_TEST) ? ENCRYPTION_KZ_GOST_34_310_SIGNATURE : (digestOID.equals(KZObjectIndentifiers.GOST_34_11_2015_512.getId()) ? KZObjectIndentifiers.GOSTR_34_10_2015_SIGNATURE_512.getId() : (digestOID.equals(KZObjectIndentifiers.GOST_34_11_2015_256.getId()) ? KZObjectIndentifiers.GOSTR_34_10_2015_SIGNATURE_256.getId() : (digestOID.equals(DIGEST_GOST3411_2012_512) ? ENCRYPTION_GOST3410_2012 : (digestOID.equals(DIGEST_GOST3411_2012_256) ? ENCRYPTION_GOST3410_2012_2 : (digestOID.equals(DIGEST_GOST3411) ? ENCRYPTION_RECGOST3410 : ENCRYPTION_RSA))))));
        }
        return encOID;
    }

    protected AlgorithmIdentifier getEncAlgorithmIdentifier(String encOid) {
        if (NO_PARAMS.contains(encOid)) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(encOid));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(encOid), new DERNull());
    }

    protected Map getBaseParameters(DERObjectIdentifier contentType, AlgorithmIdentifier digAlgId, byte[] hash) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contentType", contentType);
        param.put("digestAlgID", digAlgId);
        if (hash != null) {
            param.put("digest", hash.clone());
        }
        return param;
    }

    protected ASN1Set getAttributeSet(AttributeTable attr) {
        if (attr != null) {
            return new DERSet(attr.toASN1EncodableVector());
        }
        return null;
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        this._certs.addAll(CMSUtils.getCertificatesFromStore(certStore));
        this._crls.addAll(CMSUtils.getCRLsFromStore(certStore));
    }

    public void addAttributeCertificates(X509Store store) throws CMSException {
        try {
            for (X509AttributeCertificate attrCert : store.getMatches(null)) {
                this._certs.add(new DERTaggedObject(false, 2, AttributeCertificate.getInstance(ASN1Object.fromByteArray(attrCert.getEncoded()))));
            }
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing attribute certs", e);
        }
        catch (IOException e) {
            throw new CMSException("error processing attribute certs", e);
        }
    }

    public void addSigners(SignerInformationStore signerStore) {
        Iterator it = signerStore.getSigners().iterator();
        while (it.hasNext()) {
            this._signers.add(it.next());
        }
    }

    public Map getGeneratedDigests() {
        return new HashMap(this._digests);
    }

    static {
        NO_PARAMS.add(ENCRYPTION_DSA);
        NO_PARAMS.add(ENCRYPTION_ECDSA);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA1);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA224);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA256);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA384);
        NO_PARAMS.add(ENCRYPTION_ECDSA_WITH_SHA512);
        EC_ALGORITHMS.put(DIGEST_SHA1, ENCRYPTION_ECDSA_WITH_SHA1);
    }
}

