/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1OutputStream;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.cms.IssuerAndSerialNumber;
import kz.gamma.asn1.cms.KeyTransRecipientInfo;
import kz.gamma.asn1.cms.RecipientIdentifier;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.cms.CMSEnvelopedHelper;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSTypedStream;
import kz.gamma.cms.RecipientId;
import kz.gamma.cms.RecipientInformation;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;

    public KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier encAlg, InputStream data) {
        super(encAlg, AlgorithmIdentifier.getInstance(info.getKeyEncryptionAlgorithm()), data);
        this._info = info;
        this._encAlg = encAlg;
        this._rid = new RecipientId();
        RecipientIdentifier r = info.getRecipientIdentifier();
        try {
            if (r.isTagged()) {
                ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
                this._rid.setSubjectKeyIdentifier(octs.getOctets());
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                ASN1OutputStream aOut = new ASN1OutputStream(bOut);
                aOut.writeObject(iAnds.getName());
                this._rid.setIssuer(bOut.toByteArray());
                this._rid.setSerialNumber(iAnds.getSerialNumber().getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid rid in KeyTransRecipientInformation");
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier oid) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals(oid)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return oid.getId();
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        byte[] encryptedKey = this._info.getEncryptedKey().getOctets();
        String keyExchangeAlgorithm = this.getExchangeEncryptionAlgorithmName(this._keyEncAlg.getObjectId());
        String alg = CMSEnvelopedHelper.INSTANCE.getSymmetricCipherName(this._encAlg.getObjectId().getId());
        try {
            Key sKey;
            Cipher keyCipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(keyExchangeAlgorithm, prov);
            try {
                keyCipher.init(4, key);
                sKey = keyCipher.unwrap(encryptedKey, alg, 3);
            }
            catch (GeneralSecurityException e) {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            catch (IllegalStateException e) {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            catch (UnsupportedOperationException e) {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CMSException("illegal blocksize in message.", e);
        }
        catch (BadPaddingException e) {
            throw new CMSException("bad padding in message.", e);
        }
    }
}

