/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.core;

import java.io.IOException;
import java.math.BigInteger;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Object;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.core.UtilCM;

public class GammaGOST3410PublicKey {
    static final DERObjectIdentifier gostR3410_2001_GammaTech_A = new DERObjectIdentifier((Object)((Object)GammaObjectIndentifiers.GOST_id) + ".1.5.8");
    static final DERObjectIdentifier gostR3410_94 = new DERObjectIdentifier((Object)((Object)GammaObjectIndentifiers.GOST_id) + ".1.2.2");
    private double bType = 6.0;
    private double bVersion = 2.0;
    private byte[] reserved = new byte[]{0, 0};
    private int algID = 32803;
    private int magic = 826492160;
    private int magicDH = 826819584;
    private int bitlen;
    private byte[] keyBlob;
    private BigInteger keyX = null;
    private BigInteger keyY = null;
    private BigInteger keyBlobBigInt = null;
    private String keyString = null;
    private static GammaGOST3410PublicKey gammaGOST3410PublicKeyinstance;

    public static GammaGOST3410PublicKey getInstance() {
        if (gammaGOST3410PublicKeyinstance == null) {
            gammaGOST3410PublicKeyinstance = new GammaGOST3410PublicKey();
        }
        return gammaGOST3410PublicKeyinstance;
    }

    public void setKeyBlob(byte[] blob) {
        this.bType = blob[0];
        this.bVersion = blob[1];
        if (this.bType == 6.0 && this.bVersion == 2.0) {
            this.reserved = UtilCM.copyByte(blob, 2, 2);
            this.algID = UtilCM.byteToInt(blob, 4);
            this.magic = UtilCM.byteToInt(blob, 8);
            this.bitlen = UtilCM.byteToInt(blob, 12);
            this.keyBlob = new byte[this.bitlen / 8];
            this.keyBlob = UtilCM.copyByte(blob, 16, this.bitlen / 8);
            this.updateDependencies();
        } else {
            this.bType = 6.0;
            this.bVersion = 2.0;
        }
    }

    public void setKeyBlob(SubjectPublicKeyInfo pInfo) {
        DERBitString bits = pInfo.getPublicKeyData();
        byte[] tmp = bits.getBytes();
        this.bType = tmp[0];
        this.bVersion = tmp[1];
        if (this.bType == 6.0 && this.bVersion == 2.0) {
            this.setKeyBlob(tmp);
        } else {
            ASN1OctetString key;
            this.bType = 6.0;
            this.bVersion = 2.0;
            ASN1InputStream aIn = new ASN1InputStream(bits.getBytes());
            try {
                key = (ASN1OctetString)aIn.readObject();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("error recovering public key");
            }
            this.algID = pInfo.getAlgorithmId().getObjectId().equals(gostR3410_94) ? 43571 : 43578;
            byte[] keyEnc = key.getOctets();
            this.bitlen = keyEnc.length * 8;
            this.keyBlob = new byte[this.bitlen / 8];
            this.keyBlob = UtilCM.copyByte(keyEnc, 0, this.bitlen / 8);
            this.updateDependencies();
        }
    }

    public SubjectPublicKeyInfo getKeySubject() {
        if (this.algID == 43578) {
            GOST3410PublicKeyAlgParameters params = new GOST3410PublicKeyAlgParameters(gostR3410_2001_GammaTech_A, GammaObjectIndentifiers.gostR3411.getDERObjectIdentifier());
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(gostR3410_2001_GammaTech_A, params.getDERObject()), new DEROctetString(this.keyBlob));
        }
        GOST3410PublicKeyAlgParameters params = new GOST3410PublicKeyAlgParameters(gostR3410_94, GammaObjectIndentifiers.gostR3411.getDERObjectIdentifier());
        return new SubjectPublicKeyInfo(new AlgorithmIdentifier(gostR3410_94, params.getDERObject()), new DEROctetString(this.keyBlob));
    }

    public ASN1EncodableVector getKeyASN() {
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        AlgorithmIdentifier algOID = this.algID == 43578 ? new AlgorithmIdentifier(gostR3410_2001_GammaTech_A, new DERNull()) : new AlgorithmIdentifier(gostR3410_94, new DERNull());
        DERBitString bitstr = new DERBitString(this.getKey());
        v1.add(algOID);
        v1.add(bitstr);
        return v1;
    }

    public void setKey(byte[] blob, int algID) {
        this.algID = algID;
        this.bitlen = blob.length * 8;
        this.keyBlob = new byte[this.bitlen / 8];
        this.keyBlob = UtilCM.copyByte(blob, 0, this.bitlen / 8);
        this.updateDependencies();
    }

    public void setKeyDH(byte[] blob) {
        this.algID = 43571;
        this.bitlen = blob.length * 8;
        this.keyBlob = new byte[this.bitlen / 8];
        this.keyBlob = UtilCM.copyByte(blob, 0, this.bitlen / 8);
        this.updateDependencies();
    }

    public byte[] getKey() {
        int i;
        int lenBlob = this.keyBlob.length + 16;
        byte[] out = new byte[lenBlob];
        int indx = 0;
        out[indx] = (byte)this.bType;
        out[++indx] = (byte)this.bVersion;
        ++indx;
        for (int i2 = 0; i2 < this.reserved.length; ++i2) {
            out[i2 + indx] = this.reserved[i2];
        }
        indx += this.reserved.length;
        byte[] bAlgId = UtilCM.inverseCopyByte(UtilCM.intToByte(this.algID), 0, UtilCM.intToByte(this.algID).length);
        for (int i3 = 0; i3 < bAlgId.length; ++i3) {
            out[i3 + indx] = bAlgId[i3];
        }
        indx += bAlgId.length;
        byte[] bmagic = UtilCM.inverseCopyByte(UtilCM.intToByte(this.magic), 0, UtilCM.intToByte(this.magic).length);
        for (int i4 = 0; i4 < bmagic.length; ++i4) {
            out[i4 + indx] = bmagic[i4];
        }
        indx += bmagic.length;
        byte[] bbitlen = UtilCM.inverseCopyByte(UtilCM.intToByte(this.bitlen), 0, UtilCM.intToByte(this.bitlen).length);
        for (i = 0; i < bbitlen.length; ++i) {
            out[i + indx] = bbitlen[i];
        }
        indx += bbitlen.length;
        for (i = 0; i < this.keyBlob.length; ++i) {
            out[i + indx] = this.keyBlob[i];
        }
        return out;
    }

    public int getAlgID() {
        return this.algID;
    }

    public BigInteger getKeyBlob() {
        return this.keyBlobBigInt;
    }

    public byte[] getKeyBlobByte() {
        return this.keyBlob;
    }

    public BigInteger getKeyX() {
        return this.keyX;
    }

    public BigInteger getKeyY() {
        return this.keyY;
    }

    public String keyToStr() {
        return this.keyString;
    }

    public void setKeyBlob(byte[] X, byte[] Y) {
        int i;
        int len = X.length + Y.length;
        this.bitlen = len * 8;
        this.keyBlob = new byte[len];
        for (i = 0; i < X.length; ++i) {
            this.keyBlob[i] = X[i];
        }
        for (i = 0; i < Y.length; ++i) {
            this.keyBlob[i + X.length] = Y[i];
        }
        this.updateDependencies();
    }

    public byte[] getBlobByte(byte[] param1, byte[] param2) {
        int i;
        int indx = 0;
        byte[] out = new byte[param1.length + param2.length - 2];
        for (i = 1; i < param1.length; ++i) {
            out[indx] = param1[i];
            ++indx;
        }
        for (i = 1; i < param2.length; ++i) {
            out[indx] = param2[i];
            ++indx;
        }
        return out;
    }

    public boolean checkOpenKeyBlob(byte[] blob) {
        return blob[0] == 6 && blob[1] == 2;
    }

    public byte[] getKeyYAsByteArray() {
        return UtilCM.inverseCopyByte(this.keyBlob, 32, 32);
    }

    public byte[] getKeyXAsByteArray() {
        return UtilCM.inverseCopyByte(this.keyBlob, 0, 32);
    }

    private void updateDependencies() {
        if (this.algID == 43578) {
            byte[] param = this.getKeyXAsByteArray();
            this.keyX = new BigInteger(1, param);
            param = this.getKeyYAsByteArray();
            this.keyY = new BigInteger(1, param);
            this.keyBlobBigInt = new BigInteger(1, this.keyBlob);
            this.keyString = UtilCM.array2hex(this.keyBlob);
        } else {
            this.keyBlobBigInt = new BigInteger(1, this.keyBlob);
            this.keyString = UtilCM.array2hex(this.keyBlob);
        }
    }

    public static byte[] convertToGammaPublicKey(byte[] publicKey, int algID) throws Exception {
        ASN1Object asn1OctetString = ASN1OctetString.fromByteArray(publicKey);
        byte[] pubKey = ((DEROctetString)asn1OctetString).getOctets();
        GammaGOST3410PublicKey gammaGOST3410PublicKey = GammaGOST3410PublicKey.getInstance();
        gammaGOST3410PublicKey.setKey(pubKey, algID);
        byte[] gammaKey = gammaGOST3410PublicKey.getKey();
        return gammaKey;
    }
}

