/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.X509CertificateStructure;
import kz.gamma.cms.CMSSignedData;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.util.encoders.Base64;

public class UtilCM {
    private static final int MAX_BASE32_SIZE = 100;
    public static final String hexChars = "0123456789ABCDEF";
    public static final int SUN_CPU_ENDIAN_LITTLE = 0;
    public static final int SUN_CPU_ENDIAN_BIG = 1;

    public static String toHexByte(int val) {
        return "" + hexChars.charAt(val >> 4 & 0xF) + hexChars.charAt(val & 0xF);
    }

    public String getHexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static byte[] hex2array(String hex) {
        int hexLength = hex.length();
        byte[] data = new byte[hexLength / 2];
        for (int i = 0; i < hexLength; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static String arrayToBase64(byte[] value) {
        if (value == null) {
            return null;
        }
        return new String(Base64.encode(value));
    }

    public static String array2hex(byte[] value) {
        StringBuilder ret = new StringBuilder();
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                ret.append(UtilCM.toHexByte(value[i]));
            }
        }
        return ret.toString();
    }

    public static String array2hex(byte[] value, int size) {
        return UtilCM.array2hex(value, 0, size);
    }

    public static String array2hex(byte[] value, int offset, int size) {
        StringBuilder ret = new StringBuilder();
        for (int i = offset; i < offset + size; ++i) {
            ret.append(UtilCM.toHexByte(value[i]));
        }
        return ret.toString();
    }

    @Deprecated
    public static int byteToInt(byte[] x, int offset) {
        return UtilCM.byteToInt(x, offset, 1);
    }

    public static short byteToShort(byte[] x, int offset, int type) {
        switch (type) {
            case 0: {
                return (short)(x[offset++] & 0xFF | (x[offset++] & 0xFF) << 8);
            }
            case 1: {
                return (short)((x[offset++] & 0xFF) << 8 | x[offset++] & 0xFF);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static int byteToShortInt(byte[] x, int offset, int type) {
        switch (type) {
            case 0: {
                return x[offset++] & 0xFF | (x[offset++] & 0xFF) << 8;
            }
            case 1: {
                return (x[offset++] & 0xFF) << 8 | x[offset++] & 0xFF;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static int byteToInt(byte[] x, int offset, int type) {
        int valueArrayLength = x.length - offset;
        if (valueArrayLength < 1 || valueArrayLength > 4) {
            throw new IllegalArgumentException("Wrong number value byte array length: " + valueArrayLength + ". Allow 1-4 bytes.");
        }
        switch (type) {
            case 0: {
                int res = x[offset++] & 0xFF;
                if (valueArrayLength > 1) {
                    res |= (x[offset++] & 0xFF) << 8;
                }
                if (valueArrayLength > 2) {
                    res |= (x[offset++] & 0xFF) << 16;
                }
                if (valueArrayLength > 3) {
                    res |= x[offset++] << 24;
                }
                return res;
            }
            case 1: {
                int res = x[offset + --valueArrayLength] & 0xFF;
                if (valueArrayLength > 0) {
                    res |= (x[offset + --valueArrayLength] & 0xFF) << 8;
                }
                if (valueArrayLength > 0) {
                    res |= (x[offset + --valueArrayLength] & 0xFF) << 16;
                }
                if (valueArrayLength > 0) {
                    res |= x[offset + --valueArrayLength] << 24;
                }
                return res;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static long byteToLong(byte[] x, int offset, int type) {
        long result = 0L;
        switch (type) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    long tmp = x[offset++];
                    result |= (tmp & 0xFFL) << i * 8;
                }
                break;
            }
            case 1: {
                for (int i = 7; i >= 0; --i) {
                    long tmp = x[offset++];
                    result |= (tmp & 0xFFL) << i * 8;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type: " + type);
            }
        }
        return result;
    }

    @Deprecated
    public static byte[] intToByte(int x) {
        return UtilCM.intToByte(x, 1);
    }

    public static byte[] shortToByte(short x, int type) {
        byte[] out = new byte[2];
        switch (type) {
            case 0: {
                out[0] = (byte)x;
                out[1] = (byte)(x >>> 8);
                return out;
            }
            case 1: {
                out[0] = (byte)(x >>> 8);
                out[1] = (byte)x;
                return out;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static byte[] intToByte(int x, int type) {
        byte[] out = new byte[4];
        switch (type) {
            case 0: {
                out[0] = (byte)x;
                out[1] = (byte)(x >>> 8);
                out[2] = (byte)(x >>> 16);
                out[3] = (byte)(x >>> 24);
                return out;
            }
            case 1: {
                out[0] = (byte)(x >>> 24);
                out[1] = (byte)(x >>> 16);
                out[2] = (byte)(x >>> 8);
                out[3] = (byte)x;
                return out;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static byte[] longToByte(long x, int type) {
        byte[] out = new byte[8];
        switch (type) {
            case 0: {
                out[0] = (byte)x;
                out[1] = (byte)(x >>> 8);
                out[2] = (byte)(x >>> 16);
                out[3] = (byte)(x >>> 24);
                out[4] = (byte)(x >>> 32);
                out[5] = (byte)(x >>> 40);
                out[6] = (byte)(x >>> 48);
                out[7] = (byte)(x >>> 56);
                return out;
            }
            case 1: {
                out[0] = (byte)(x >>> 56);
                out[1] = (byte)(x >>> 48);
                out[2] = (byte)(x >>> 40);
                out[3] = (byte)(x >>> 32);
                out[4] = (byte)(x >>> 24);
                out[5] = (byte)(x >>> 16);
                out[6] = (byte)(x >>> 8);
                out[7] = (byte)x;
                return out;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static byte[] addressToByte(Number address, int type) {
        if (TumarCspFunctions.getLibraryBit() == 32) {
            return UtilCM.intToByte(address.intValue(), type);
        }
        if (TumarCspFunctions.getLibraryBit() == 64) {
            return UtilCM.longToByte(address.longValue(), type);
        }
        throw new RuntimeException("Unknown library bit: " + TumarCspFunctions.getLibraryBit());
    }

    public static byte[] copyByte(byte[] x, int offset, int size) {
        byte[] out = new byte[size];
        System.arraycopy(x, offset, out, 0, size);
        return out;
    }

    public static byte[] inverseCopyByte(byte[] x, int offset, int size) {
        byte[] out = new byte[size];
        for (int i = 0; i < size; ++i) {
            out[size - i - 1] = x[offset + i];
        }
        return out;
    }

    public static byte[] inverseByte(byte[] x) {
        return UtilCM.inverseCopyByte(x, 0, x.length);
    }

    public static byte[] copyByte(byte[] x, int offset, int size, int type) {
        switch (type) {
            case 0: {
                return UtilCM.inverseCopyByte(x, offset, size);
            }
            case 1: {
                return UtilCM.copyByte(x, offset, size);
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    @Deprecated
    public static String getFullProfileName(String urlOrProfile, String param, int paramType) {
        return UtilCM.getUrl(urlOrProfile, param, paramType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrl(String urlOrProfile, String param, int paramType) {
        Number hProvLocal = 0;
        try {
            String url;
            urlOrProfile = urlOrProfile == null ? "" : urlOrProfile.trim();
            param = param == null ? "" : param.trim();
            hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456);
            String string = url = TumarCspFunctions.cpUrlToNewUrl(urlOrProfile, param, paramType, hProvLocal);
            return string;
        }
        finally {
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
    }

    public static byte[] concat(byte[] A, byte[] B) {
        if (A == null && B == null) {
            return null;
        }
        if (A == null) {
            return B;
        }
        if (B == null) {
            return A;
        }
        byte[] C = new byte[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    public static byte[] reverseParts(byte[] data, int offset) {
        byte[] firstPart = UtilCM.inverseCopyByte(data, offset, (data.length - offset) / 2);
        byte[] secondPart = UtilCM.inverseCopyByte(data, offset + (data.length - offset) / 2, (data.length - offset) / 2);
        return UtilCM.concat(firstPart, secondPart);
    }

    public static byte[] swapParts(byte[] data, int offset) {
        byte[] firstPart = UtilCM.copyByte(data, offset, (data.length - offset) / 2);
        byte[] secondPart = UtilCM.copyByte(data, offset + (data.length - offset) / 2, (data.length - offset) / 2);
        return UtilCM.concat(secondPart, firstPart);
    }

    public static int calcCRC(byte[] data) {
        int[] crc_table = new int[256];
        int crc = 0;
        for (int i = 0; i < 256; ++i) {
            long c = i;
            for (int j = 0; j < 8; ++j) {
                long p = c & 1L;
                c = c >> 1 ^ (p != 0L ? 3988292384L : 0L);
            }
            crc_table[i] = (int)c;
        }
        for (byte b : data) {
            crc = crc >>> 8 ^ crc_table[(crc ^ b) & 0xFF];
        }
        return crc ^= 0xFFFFFFFF;
    }

    public static String hash2Ref(byte[] hash) {
        return UtilCM.bin2base32(hash, 0, 20);
    }

    public static String bin2base32(byte[] bin, int offset, int size) {
        int i;
        if (size > 100) {
            throw new RuntimeException("Max size is 100");
        }
        char[] base32 = new char[size * 8 / 5];
        byte[] bp = new byte[2];
        byte[] a = new byte[size * 8];
        String alf = "0123456789ABCDEFGHJKMNPRSTUVWXYZ";
        for (i = 0; i < size; ++i) {
            int j = 0;
            int t = 128;
            while (j < 8) {
                bp[1] = 0;
                bp[0] = bin[i + offset];
                short q1 = UtilCM.byteToShort(bp, 0, LibraryWrapper.SUN_CPU_ENDIAN);
                a[i * 8 + j] = (q1 & t) != 0 ? (byte)1 : 0;
                ++j;
                t >>>= 1;
            }
        }
        for (i = 0; i < size * 8 / 5; ++i) {
            base32[i] = alf.charAt(a[i * 5] << 4 | a[i * 5 + 1] << 3 | a[i * 5 + 2] << 2 | a[i * 5 + 3] << 1 | a[i * 5 + 4]);
        }
        return new String(base32);
    }

    public static byte[] makeIDKey() throws NoSuchAlgorithmException {
        Calendar calendar = Calendar.getInstance();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        return messageDigest.digest(calendar.getTime().toString().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCertificateBlob(byte[] blob) {
        byte[] ret = null;
        try {
            CMSSignedData signedData = new CMSSignedData(blob);
            CertStore store1 = signedData.getCertificatesAndCRLs("Collection", null);
            Collection<? extends Certificate> crtColl = store1.getCertificates(new X509CertSelector());
            Iterator<? extends Certificate> itcert = crtColl.iterator();
            if (itcert.hasNext()) {
                X509Certificate ccer = (X509Certificate)itcert.next();
                ret = ccer.getEncoded();
            }
        }
        catch (Exception e) {
            ret = null;
        }
        ASN1InputStream in = null;
        try {
            if (ret == null) {
                in = new ASN1InputStream(blob);
                DERSequence crtBlob = (DERSequence)in.readObject();
                X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(crtBlob);
                ret = x509CertificateStructure.getEncoded();
            }
        }
        catch (Exception e) {
            ret = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    static byte[] concatenate(byte[] ... args) {
        int length = 0;
        int pos = 0;
        for (byte[] arg : args) {
            length += arg.length;
        }
        byte[] result = new byte[length];
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, result, pos, arg.length);
            pos += arg.length;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Certificate> getCertificatesBlob(byte[] blob) {
        LinkedList<Certificate> ret = new LinkedList<Certificate>();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
            CMSSignedData signedData = new CMSSignedData(blob);
            CertStore store1 = signedData.getCertificatesAndCRLs("Collection", null);
            Collection<? extends Certificate> crtColl = store1.getCertificates(new X509CertSelector());
            Iterator<? extends Certificate> itcert = crtColl.iterator();
            while (itcert.hasNext()) {
                Certificate ccer = cf.generateCertificate(new ByteArrayInputStream(((X509Certificate)itcert.next()).getEncoded()));
                ret.add(ccer);
            }
        }
        catch (Exception cf) {
            // empty catch block
        }
        FilterInputStream in = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
            if (ret == null) {
                in = new ASN1InputStream(blob);
                DERSequence crtBlob = (DERSequence)((ASN1InputStream)in).readObject();
                Certificate cert = cf.generateCertificate(new ByteArrayInputStream(crtBlob.getEncoded()));
                ret.add(cert);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static byte[] trimArray(byte[] array, int size) {
        if (array == null) {
            return null;
        }
        if (array.length == size) {
            return array;
        }
        byte[] res = new byte[size];
        System.arraycopy(array, 0, res, 0, size);
        return res;
    }

    public static void saveFile(byte[] data, String fileName) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(fileName));
            fileOutputStream.write(data);
            fileOutputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static X509Certificate loadCertFromFile(String fileName) throws CertificateException, IOException, NoSuchProviderException {
        return UtilCM.loadCertFromFile(fileName, false);
    }

    public static X509Certificate loadCertFromFile(String fileName, boolean isB64) throws IOException, CertificateException, NoSuchProviderException {
        FileInputStream f = new FileInputStream(fileName);
        byte[] buf = new byte[f.available()];
        f.read(buf, 0, f.available());
        f.close();
        if (isB64) {
            buf = Base64.decode(buf);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(buf));
        return cert;
    }

    public static ArrayList<X509Certificate> getAllCertsFromDir(String path) throws CertificateException, IOException, NoSuchProviderException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        File folder = new File(path);
        for (File fileEntry : folder.listFiles()) {
            if (!fileEntry.isFile()) continue;
            certs.add(UtilCM.loadCertFromFile(fileEntry.getAbsolutePath()));
        }
        return certs;
    }

    public static X509Certificate loadCertFromBlob(byte[] buf) throws CertificateException, NoSuchProviderException {
        if (buf == null) {
            return null;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(buf));
        return cert;
    }

    public static byte[] loadFile(String fileName) throws IOException {
        return Files.readAllBytes(Paths.get(fileName, new String[0]));
    }
}

