/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.core.archive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kz.gamma.crypto.RuntimeCryptoException;

public class GzipArchiver {
    public byte[] gzip(byte[] data) {
        ByteArrayInputStream bin = null;
        DeflaterOutputStream gzipout = null;
        ByteArrayOutputStream bout = null;
        try {
            bin = new ByteArrayInputStream(data);
            bout = new ByteArrayOutputStream();
            gzipout = new GZIPOutputStream(bout);
            int c22 = bin.read();
            while (c22 != -1) {
                gzipout.write(c22);
                c22 = bin.read();
            }
            gzipout.close();
            bin.close();
            byte[] c22 = bout.toByteArray();
            return c22;
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Cannot create archive");
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (gzipout != null) {
                try {
                    gzipout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public byte[] ungzip(byte[] compressedData) {
        ByteArrayInputStream bin = null;
        GZIPInputStream gzipin = null;
        ByteArrayOutputStream bout = null;
        try {
            bin = new ByteArrayInputStream(compressedData);
            bout = new ByteArrayOutputStream();
            gzipin = new GZIPInputStream(bin);
            int c22 = gzipin.read();
            while (c22 != -1) {
                bout.write(c22);
                c22 = gzipin.read();
            }
            gzipin.close();
            bin.close();
            byte[] c22 = bout.toByteArray();
            return c22;
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Cannot extract archive");
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (gzipin != null) {
                try {
                    gzipin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

