/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.core.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JFileChooser;
import kz.gamma.core.file.KeyFileFilter;

public class FileHelper {
    public Boolean createFile(final String path) throws Exception {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File defaultDir = new File(path);
                Boolean isDirectory = defaultDir.isDirectory();
                Boolean isExists = defaultDir.exists();
                if (!isExists.booleanValue()) {
                    Stack<File> toCreate = new Stack<File>();
                    toCreate.add(defaultDir);
                    File file = defaultDir;
                    while (!(file = file.getParentFile()).exists()) {
                        toCreate.add(file);
                    }
                    while (!toCreate.isEmpty()) {
                        file = (File)toCreate.pop();
                        file.mkdir();
                    }
                    isExists = defaultDir.exists();
                } else if (isExists.booleanValue() && !isDirectory.booleanValue()) {
                    throw new RuntimeException("File \"" + path + "\" is exists and not a directory");
                }
                return isExists;
            }
        });
        return result;
    }

    public String getUserHomePath() {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        return path;
    }

    public String getDefaultKeysPath() {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home") + File.separator + "TumarCSP";
            }
        });
        return path;
    }

    public void saveData(final byte[] dataToSave, final String fileName) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileOutputStream fos = null;
                ByteArrayOutputStream bous = null;
                try {
                    File file = new File(fileName);
                    FileHelper.this.createFile(file.getParent());
                    fos = new FileOutputStream(fileName);
                    bous = new ByteArrayOutputStream();
                    bous.write(dataToSave);
                    bous.writeTo(fos);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (bous != null) {
                        try {
                            bous.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return null;
            }
        });
    }

    public String saveResource(final String resourcePackage, final String resourceName) {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    int bytesRead;
                    is = this.getClass().getResourceAsStream(resourcePackage + resourceName);
                    File file = new File(System.getProperty("java.io.tmpdir") + "/" + resourceName);
                    FileHelper.this.createFile(file.getParent());
                    fos = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                    String string = file.toString();
                    return string;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        return path;
    }

    public byte[] loadData(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fileName);
                    int size = fis.available();
                    byte[] result = new byte[size];
                    fis.read(result, 0, size);
                    byte[] byArray = result;
                    return byArray;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public Boolean isFileExists(final String path) throws Exception {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = new File(path);
                return file.exists();
            }
        });
        return result;
    }

    public boolean deleteData(final String path) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = new File(path);
                if (file.exists() && file.isDirectory()) {
                    File[] files;
                    for (File localFile : files = file.listFiles()) {
                        if (localFile.isDirectory()) {
                            FileHelper.this.deleteData(localFile.getAbsolutePath());
                            continue;
                        }
                        localFile.delete();
                    }
                }
                return file.delete();
            }
        });
    }

    public List<File> find(String startPath, String fileName, String fileExt) {
        if (startPath == null || startPath.trim().equals("")) {
            throw new RuntimeException("You must set start path");
        }
        if (fileName == null || fileName.trim().equals("")) {
            throw new RuntimeException("You must set file name");
        }
        if (fileExt == null || fileExt.trim().equals("")) {
            throw new RuntimeException("You must set file extension");
        }
        File topDirectory = new File(startPath);
        if (!topDirectory.exists()) {
            throw new RuntimeException("Start path directory is not exist");
        }
        LinkedList<File> resultList = new LinkedList<File>();
        this.search(topDirectory, resultList, fileName, fileExt);
        return resultList;
    }

    private void search(File startDirectory, List<File> resultList, String fileName, String fileExt) {
        File[] filesArray;
        for (File file : filesArray = startDirectory.listFiles()) {
            if (file.isDirectory()) {
                this.search(file, resultList, fileName, fileExt);
                continue;
            }
            if (!file.getName().matches(fileName + "." + fileExt)) continue;
            resultList.add(file);
        }
    }

    public String createDialog(final List extensions, final String description, final Integer type) {
        if (type == null) {
            throw new NullPointerException("parameter type must not be null");
        }
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                JFileChooser chooser = new JFileChooser();
                String filePath = null;
                int selectionMode = 0;
                chooser.setFileSelectionMode(selectionMode);
                if (extensions != null && extensions.size() != 0) {
                    String[] extArray = new String[extensions.size()];
                    for (int i = 0; i < extensions.size(); ++i) {
                        extArray[i] = (String)extensions.get(i);
                    }
                    KeyFileFilter keyFileFilter = new KeyFileFilter(extArray, description);
                    chooser.addChoosableFileFilter(keyFileFilter);
                }
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setDialogType(type);
                String approveButtonText = "\u0412\u044b\u0431\u0440\u0430\u0442\u044c";
                switch (type) {
                    case 0: {
                        approveButtonText = "\u041e\u0442\u043a\u0440\u044b\u0442\u044c";
                        break;
                    }
                    case 1: {
                        approveButtonText = "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal type: " + type);
                    }
                }
                int result = chooser.showDialog(null, approveButtonText);
                if (result == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    switch (type) {
                        case 0: {
                            if (selectedFile.isFile()) break;
                            throw new RuntimeException("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u043e\u043c");
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal type: " + type);
                        }
                    }
                    try {
                        filePath = selectedFile.getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    filePath = "";
                }
                return filePath;
            }
        });
        return path;
    }
}

