/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto;

public class Info {
    public static String codeToFail(int code) {
        switch (code) {
            case 0: {
                return "unrecognized or unsupported Algorithm Identifier";
            }
            case 1: {
                return "integrity check failed (e.g., signature did not verify)";
            }
            case 2: {
                return "transaction not permitted or supported";
            }
            case 3: {
                return "messageTime was not sufficiently close to the system time, as defined by local policy";
            }
            case 4: {
                return "no certificate could be found matching the provided criteria";
            }
            case 5: {
                return "the data submitted has the wrong format";
            }
            case 6: {
                return "the authority indicated in the request is different from the one creating the response token";
            }
            case 7: {
                return "the requester's data is incorrect (for notary services)";
            }
            case 8: {
                return "when the timestamp is missing but should be there (by policy)";
            }
            case 9: {
                return "the proof-of-possession failed";
            }
            case 10: {
                return "the certificate has already been revoked";
            }
            case 11: {
                return "the certificate has already been confirmed";
            }
            case 12: {
                return "invalid integrity, password based instead of signature or vice versa";
            }
            case 13: {
                return "invalid recipient nonce, either missing or wrong value";
            }
            case 14: {
                return "the TSA's time source is not available";
            }
            case 15: {
                return "the requested TSA policy is not supported by the TSA";
            }
            case 16: {
                return "the requested extension is not supported by the TSA";
            }
            case 17: {
                return "the additional information requested could not be understood or is not available";
            }
            case 18: {
                return "invalid sender nonce, either missing or wrong size";
            }
            case 19: {
                return "invalid certificate template or missing mandatory information";
            }
            case 20: {
                return "signer of the message unknown or not trusted";
            }
            case 21: {
                return "the transaction identifier is already in use";
            }
            case 22: {
                return "the version of the message is not supported";
            }
            case 23: {
                return "not authorised";
            }
            case 24: {
                return "the request cannot be handled due to system unavailability";
            }
            case 25: {
                return "the request cannot be handled due to system failure";
            }
            case 26: {
                return "certificate cannot be issued because a duplicate certificate already exists";
            }
        }
        return "Unknown";
    }

    public static String keyUsageToString(int code) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((code & 0x80) > 0) {
            stringBuilder.append("digitalSignature, ");
        }
        if ((code & 0x40) > 0) {
            stringBuilder.append("nonRepudiation, ");
        }
        if ((code & 0x20) > 0) {
            stringBuilder.append("keyEncipherment, ");
        }
        if ((code & 0x10) > 0) {
            stringBuilder.append("dataEncipherment, ");
        }
        if ((code & 8) > 0) {
            stringBuilder.append("keyAgreement, ");
        }
        if ((code & 4) > 0) {
            stringBuilder.append("keyCertSign, ");
        }
        if ((code & 2) > 0) {
            stringBuilder.append("cRLSign, ");
        }
        if ((code & 1) > 0) {
            stringBuilder.append("encipherOnly, ");
        }
        if ((code & 0x8000) > 0) {
            stringBuilder.append("decipherOnly, ");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }
}

