/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.chiper;

import kz.gamma.pkcs11.jna.CK_ATTRIBUTE;
import kz.gamma.pkcs11.jna.CK_MECHANISM;
import kz.gamma.pkcs11.jna.PKCS11Utils;
import kz.gamma.pkcs11.jna.Pkcs11Exception;
import kz.gamma.pkcs11.jna.Pkcs11JnaWrapper;

public class PKCS11Cipher {
    private long session;
    private long mechanismId;
    private boolean withPadding;

    private void processMechanism(long mechanismId) {
        if (mechanismId == 4229L) {
            this.withPadding = true;
            return;
        }
        if (mechanismId == 4226L) {
            return;
        }
        throw new IllegalArgumentException("Unsupported mechanism Id: " + mechanismId);
    }

    public PKCS11Cipher(char[] tokenPassword, long mechanismId) {
        this.processMechanism(mechanismId);
        this.session = PKCS11Utils.connect(tokenPassword);
        this.mechanismId = mechanismId;
    }

    public void encryptInit(long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.C_EncryptInit(this.session, this.mechanismId, hKey);
    }

    public byte[] encryptUpdate(byte[] part) throws Pkcs11Exception {
        byte[] ret = Pkcs11JnaWrapper.C_EncryptUpdate(this.session, part);
        return ret;
    }

    public byte[] encryptFinal() throws Pkcs11Exception {
        byte[] ret = Pkcs11JnaWrapper.C_EncryptFinal(this.session);
        return ret;
    }

    public void decryptInit(long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.C_DecryptInit(this.session, this.mechanismId, hKey);
    }

    public byte[] decryptUpdate(byte[] part) throws Pkcs11Exception {
        byte[] ret = Pkcs11JnaWrapper.C_DecryptUpdate(this.session, part);
        return ret;
    }

    public byte[] decryptFinal() throws Pkcs11Exception {
        byte[] ret = Pkcs11JnaWrapper.C_DecryptFinal(this.session);
        return ret;
    }

    public byte[] doEncrypt(byte[] data, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.C_EncryptInit(this.session, this.mechanismId, hKey);
        byte[] ret = Pkcs11JnaWrapper.C_Encrypt(this.session, data, this.withPadding);
        return ret;
    }

    public byte[] doDecrypt(byte[] data, long hKey) throws Pkcs11Exception {
        Pkcs11JnaWrapper.C_DecryptInit(this.session, this.mechanismId, hKey);
        byte[] ret = Pkcs11JnaWrapper.C_Decrypt(this.session, data);
        return ret;
    }

    public long genSecretKey(String keyName, int secretKeySizeBytes) throws Exception {
        CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(8);
        attributes[0].setAttr((Long)0L, 4L);
        attributes[1].setAttr((Long)256L, 31L);
        attributes[2].setAttr((Long)1L, true);
        attributes[3].setAttr((Long)260L, true);
        attributes[4].setAttr((Long)261L, true);
        attributes[5].setAttr((Long)3L, keyName);
        attributes[6].setAttr((Long)262L, true);
        attributes[7].setAttr((Long)353L, secretKeySizeBytes);
        CK_MECHANISM ckmRSAKeyGenMech = new CK_MECHANISM(4224L);
        long key = Pkcs11JnaWrapper.C_GenerateKey(this.session, ckmRSAKeyGenMech, attributes);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] wrapKey(long hKeyToBeWrapped, byte[] publicKeyValue, int keySizeBytes) throws Pkcs11Exception {
        long publicKeyId = PKCS11Utils.getPublicKey(this.session, publicKeyValue);
        long tempPublicKeyId = 0L;
        if (publicKeyId == 0L) {
            tempPublicKeyId = publicKeyId = PKCS11Utils.createPublicKey(this.session, publicKeyValue);
        }
        try {
            byte[] byArray = Pkcs11JnaWrapper.C_WrapKey(this.session, 1L, publicKeyId, hKeyToBeWrapped, keySizeBytes);
            return byArray;
        }
        finally {
            if (tempPublicKeyId != 0L) {
                try {
                    Pkcs11JnaWrapper.C_DestroyObject(this.session, tempPublicKeyId);
                }
                catch (Exception exception) {}
            }
        }
    }

    public long unwrapKey(String privateKeyName, byte[] wrappedKey, String keyName, int secretKeySizeBytes) throws Pkcs11Exception {
        long hUnwrappingKey = PKCS11Utils.getPrivateKeyId(this.session, privateKeyName);
        CK_ATTRIBUTE[] attributes = (CK_ATTRIBUTE[])new CK_ATTRIBUTE.ByReference().toArray(8);
        attributes[0].setAttr((Long)0L, 4L);
        attributes[1].setAttr((Long)256L, 31L);
        attributes[2].setAttr((Long)1L, true);
        attributes[3].setAttr((Long)260L, true);
        attributes[4].setAttr((Long)261L, true);
        attributes[5].setAttr((Long)3L, keyName);
        attributes[6].setAttr((Long)262L, true);
        attributes[7].setAttr((Long)353L, secretKeySizeBytes);
        return Pkcs11JnaWrapper.C_UnwrapKey(this.session, 1L, hUnwrappingKey, wrappedKey, attributes);
    }

    public byte[] getPublicKeyValue(String keyLabel) throws Pkcs11Exception {
        long hPublicKey = PKCS11Utils.getPublicKey(this.session, keyLabel);
        if (hPublicKey != 0L) {
            return PKCS11Utils.getPublicKeyValue(this.session, hPublicKey);
        }
        return null;
    }

    public void close() {
        try {
            PKCS11Utils.closeSession(this.session);
            this.session = 0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        PKCS11Utils.closeSession(this.session);
    }
}

