/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.params;

import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.crypto.CipherParameters;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.jce.provider.JCEECPublicKey;

public class GammaParameters
implements CipherParameters {
    private PrivateKey privKey = null;
    private JCEECPublicKey pubKey = null;
    private int hashAlgID = 32797;

    public GammaParameters(final PublicKey key) {
        if (key instanceof JCEECPublicKey) {
            this.pubKey = (JCEECPublicKey)key;
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RSAPublicKey myKey = (RSAPublicKey)key;
                    ASN1EncodableVector seq = new ASN1EncodableVector();
                    DERInteger n = new DERInteger(myKey.getModulus());
                    DERInteger e = new DERInteger(myKey.getPublicExponent());
                    seq.add(n);
                    seq.add(e);
                    DERSequence qz = new DERSequence(seq);
                    GammaParameters.this.pubKey = new JCEECPublicKey(qz.getDEREncoded(), PKCSObjectIdentifiers.rsaEncryption.getId());
                    return null;
                }
            });
        }
    }

    public GammaParameters(PrivateKey key) {
        this.privKey = key;
    }

    public byte[] getPublicKey() {
        return this.pubKey.getEncoded();
    }

    public Number getCSPHandle() {
        return ((JCEECPrivateKey)this.privKey).getHandleProv();
    }

    public int getCSPkeyType() {
        return ((JCEECPrivateKey)this.privKey).getAlgType();
    }

    public void sethashAlgID(int hshAlgID) {
        this.hashAlgID = hshAlgID;
    }

    public int gethashAlgID() {
        return this.hashAlgID;
    }

    public String getPublicKeyAlg() {
        return this.pubKey.getAlgorithm();
    }

    public PrivateKey getPrivKey() {
        return this.privKey;
    }
}

