/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc;

import java.io.IOException;
import kz.gamma.asn1.DERInteger;
import kz.gamma.core.UtilCM;
import kz.gamma.jce.exception.JCEHardwareException;

public class CreatePublicKeyHelper {
    public static byte[] getBlob(int algID, boolean isKZOID, byte[] publicKey) {
        byte[] ret = null;
        if (isKZOID) {
            try {
                DERInteger pKey = new DERInteger(UtilCM.reverseParts(publicKey, 0));
                ret = pKey.getEncoded();
            }
            catch (IOException e) {
                throw new JCEHardwareException("Error convert public key " + e.getMessage());
            }
        } else {
            switch (algID) {
                case 1: {
                    byte[] parama = new byte[]{6, 2, 0, 0, 58, -86, 0, 0, 0, 69, 67, 49, 0, 2, 0, 0};
                    ret = UtilCM.concat(parama, UtilCM.reverseParts(publicKey, 0));
                    break;
                }
                case 2: {
                    byte[] paramexa = new byte[]{6, 2, 0, 0, 69, -96, 0, 0, 0, 69, 67, 49, 0, 2, 0, 0};
                    ret = UtilCM.concat(paramexa, UtilCM.reverseParts(publicKey, 0));
                    break;
                }
                default: {
                    throw new JCEHardwareException("Error convert public key, algorithm not found");
                }
            }
        }
        return ret;
    }
}

